#include "de.h"
#include "math.h"

//------global variable for the objective function (dummy)-------
float gfa_bound[21];

//------helper function------------------------------------------
float step(float f_x)
/**C*F****************************************************************
**                                                                  
** Function       :float step(float f_x)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Step function step(f_x) is 1.0 if f_x > 0 and
**                 0.0 otherwise.
**
** Functions      :-                                                
**                                                                  
** Globals        :- 
**                                                                  
** Parameters     :f_x         (I)    input variable
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :see description.                                            
**                                                                  
***C*F*E*************************************************************/
{
	if (f_x > 0)
		return(1.0);
	else
		return(0.0);
}
//------objective function---------------------------------------

t_pop evaluate(int i_D, t_pop t_tmp, long *l_nfeval, t_pop *tpa_array, int i_NP)
/**C*F****************************************************************
**                                                                  
** Function       :t_pop evaluate(int i_D, t_pop t_tmp, long *l_nfeval,
**                                t_pop *tpa_array, int i_NP)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Objective function for Zimmermann's problem
**
**                 Known global minimum: 0.0
**                                       x1 = 7.0
**                                       x2 = 2.0
** Functions      :-                                                
**                                                                  
** Globals        :- 
**                                                                  
** Parameters     :i_D         (I)    number of parameters
**                 t_tmp       (I)    parameter vector
**                 l_nfeval   (I/O)   counter for function evaluations
**                 tpa_array   (I)    pointer to current population (not needed here)
**                 i_NP   	   (I)    number of population members (not needed here)
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :TRUE if trial vector wins, FALSE otherwise.                                            
**                                                                  
***C*F*E*************************************************************/
{
   int   i,j;
   float f_h1, f_h2, f_h3, result; //helper variables
   float f_pc1, f_pc2, f_pc3, f_pc4, f_pc5; //helper variables

   (*l_nfeval)++;

   //----cost function value to minimize-----------

   //helper functions
   f_h1 = 9.0 - t_tmp.fa_vector[0] - t_tmp.fa_vector[1];
   f_h2 = (t_tmp.fa_vector[0] - 3.0)*(t_tmp.fa_vector[0] - 3.0) + 
	      (t_tmp.fa_vector[1] - 2.0)*(t_tmp.fa_vector[1] - 2.0) - 16.0;
   f_h3 = t_tmp.fa_vector[0]*t_tmp.fa_vector[1] - 14.0;

   //partial costs
   f_pc1 = f_h1;                     
   f_pc2 = 100*(1+f_h2)*step(f_h2);
   f_pc3 = 100*(1+f_h3)*step(f_h3);
   f_pc4 = 100*(1-t_tmp.fa_vector[0])*step(-t_tmp.fa_vector[0]);
   f_pc5 = 100*(1-t_tmp.fa_vector[1])*step(-t_tmp.fa_vector[1]);

   //find maximum of partial costs
   result = f_pc1;
   if (f_pc2 > result) result = f_pc2;
   if (f_pc3 > result) result = f_pc3;
   if (f_pc4 > result) result = f_pc4;
   if (f_pc5 > result) result = f_pc5;

   t_tmp.fa_cost[0] = result;


   //----inequality constraints (must be < 0)-------
   t_tmp.fa_constraint[0] = f_h2;
   t_tmp.fa_constraint[1] = f_h3;

   return(t_tmp);
}

int left_vector_wins(t_pop trial, t_pop target)
/**C*F****************************************************************
**                                                                  
** Function       :int left_vector_wins(t_pop t_trial, t_pop t_target)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Selection criterion of DE. Decides when the trial
**                 vector wins over the target vector.                 
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :-                                                
**                                                                  
** Parameters     :t_trial    (I)   trial vector
**                 t_target   (I)   target vector   
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :TRUE if trial vector wins, FALSE otherwise.                                            
**                                                                  
***C*F*E*************************************************************/
{
	int i;
	int ctrial_satisfy  = TRUE;
	int ctarget_satisfy = TRUE;
	int constraints_improve = TRUE;

    //----all constraints are satisfied ?----------
	for (i=0; i<2; i++)
	{
		if (trial.fa_constraint[i] > 0.0) ctrial_satisfy = FALSE;
	}
	for (i=0; i<2; i++)
	{
		if (target.fa_constraint[i] > 0.0) ctarget_satisfy = FALSE;
	}

	//----make the decision dependend on the constraints-------
	if ((ctrial_satisfy == TRUE) && (ctarget_satisfy == TRUE))
	{
	   if (trial.fa_cost[0] <= target.fa_cost[0]) return(TRUE);
	   else return(FALSE);
	}

	if ((ctrial_satisfy == TRUE) && (ctarget_satisfy == FALSE))
	{
	   return(TRUE); //constraints satisfaction is always best, trial wins
	}

	if ((ctrial_satisfy == FALSE) && (ctarget_satisfy == TRUE))
	{
	   return(FALSE); //constraints satisfaction is always best, target wins
	}

	if ((ctrial_satisfy == FALSE) && (ctarget_satisfy == FALSE))
	{
	   for (i=0; i<2; i++)
	   {
		  if (trial.fa_constraint[i] > target.fa_constraint[i]) constraints_improve = FALSE;
	   }
	   if (constraints_improve == TRUE) return(TRUE);//trial wins if all constraints are equal or better
	   else return(FALSE);
	}
	return(FALSE); //default value (only compiler needs it)

}


