#include "plot.h"
//-------Global variables relevant for graphics-----------------------

//  extern float gfa_xmold[];	//MAXDIM

  char  gca_sbuft[80];        // Stringbuffer

  float gf_x_low, gf_x_high, gf_y_low, gf_y_high;

  static float  gf_x_old;          //x-coordinate of previous point
  static float  gf_y_old;          //y-coordinate of previous point
  static float  gi_first_plot = 0; //flag which turns to 1 after the first plot


//-----Initialization of graphics-------------------------------------

void graphics_init(void)
/**C*F****************************************************************
**                                                                  
** Function       :void graphics_init()                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Descripton     :Defines the coordinate system.                 
**                                                                  
** Functions      :axis()                                                
**                                                                  
** Globals        :(see code)                                                
**                                                                  
** Parameters     :-   
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :-       
**
** Return Value   :-                                                                                  
**                                                                  
***C*F*E*************************************************************/
{
  gca_sbuft[0] = '\0';            // Initialize string buffer
}


void update_graphics(float best[], int i_D, float fa_bound[], long l_nfeval, int i_gen, float f_emin, int i_strategy, int gi_genmax)
/**C*F****************************************************************
**                                                                  
** Function       :void update_graphics()                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Custom program which updates the graphics part of the
**                 differential evolution optimization.                 
**                                                                  
** Functions      :xflt(), yflt(), frect(), Cls(), axis(), draw_graph(), box(),
**                 grid(), fline(), sprintf(), myprint().                                                
**                                                                  
** Globals        :(see code)  
**                                                                  
** Parameters     :best[]        (I)    Parameter vector
**                 i_D           (I)    Dimension of the parameter vector  
**                 fa_bound[]    (I)    Array defining a tolerance scheme for the current example
**                 l_nfeval      (I)    Current number of acumulated function evaluations                                          
**                 i_gen         (I)    Current number of accumulated generations
**                 f_emin        (I)    Current best objective function value
**                 i_strategy    (I)    DE-strategy used (coded as a number)
**                 gi_genmax     (I)    Maximum number of generations   
**                                                                  
** Preconditions  :graphics_init() must have been called.                     
**                                                                  
** Postconditions :-                                             
**                  
** Return Value   :-                                                                                  
**                                                                                                                   
***C*F*E*************************************************************/
{
	int j;

//======Check whether initialization has been done====================
	     if (gi_first_plot == 0)
		 {
           // define coordinate system
           gf_x_low  = 0.0;
           gf_x_high = (float)gi_genmax;
           gf_y_low  = 0.0;
           gf_y_high = 1.0;//f_emin;

           // define axes
           axis(gf_x_low,gf_x_high,gf_y_low,gf_y_high); 

           gf_x_old = 0;
           gf_y_old = f_emin;
	       gi_first_plot = 1;
		 }

//======Begin with the new drawings.==================================
//------draw surrounding box------------------------------------------
		 box('y');//grey box

//-----draw grid------------------------------------------------------
	     grid('y',5,5);

//-----draw convergence graph-----------------------------------------

		 fline(gf_x_old, gf_y_old, (float)i_gen, f_emin,'b');
		 gf_x_old = (float)i_gen;
		 gf_y_old = f_emin;

//------Display title-----------------------------------------------------
		 sprintf(gca_sbuft,"C O N V E R G E N C E     G R A P H     (Z I M M E R M A N ' S   P R O B L E M)");
		 myprint((gf_x_low + 0.23*(gf_x_high - gf_x_low)),(gf_y_high + 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

//------Display parameters------------------------------------------------
		for (j=0; j<i_D; j++)
		{
		   sprintf(gca_sbuft,"best[%d] = %f",j,best[j]);
		   myprint((gf_x_low + 0.1*(gf_x_high - gf_x_low)),(gf_y_high - 0.9*((float)(j+1)/(float)i_D)*(gf_y_high - gf_y_low)),gca_sbuft);
		}

//------Display current number of trials----------------------------------
// x-positioning (gf_x_low + k*(gf_x_high - gf_x_low))

		 sprintf(gca_sbuft,"No. of trials:  %ld",l_nfeval);
		 myprint((gf_x_low + 0*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

//------Display current Iteration-----------------------------------------
		 sprintf(gca_sbuft,"Iteration:       %d",i_gen);
		 myprint((gf_x_low + 0.3*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

//------Display current pathlength----------------------------------------
		 sprintf(gca_sbuft,"best OFUNC value: %-11.10g",f_emin);
		 myprint((gf_x_low + 0.5*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

//------Display DE strategy-----------------------------------------------
		 sprintf(gca_sbuft,"DE-strategy No.: %d",i_strategy);
		 myprint((gf_x_low + 0.9*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

}