#include "plot.h"
#include "de.h"

//------defines----------------------------------------------------
#define SHOW_ROA  //if defined ROA plot will be shown, tolerance scheme plot otherwise

//------problem specific stuff-------------------------------------
//------Note: this is doubly defined in eval.cpp-------------------
#define MAXUP1 1.1
#define MAXUP2 0.5
#define MAXLOW 0.4

//-------Global variables relevant for graphics-----------------------

  extern float gfa_xmold[];	//MAXDIM

  char  gca_sbufi[80];        // Stringbuffer for itration display
  char  gca_sbufp[80];        // Stringbuffer for pathlength display
  char  gca_sbuft[80];        // Stringbuffer for trial display

  float gf_xgraph,gf_ygraph,gf_ygo,gf_xgo;
  float gf_x_low, gf_x_high, gf_y_low, gf_y_high;
  float gf_x_l, gf_x_h, gf_y_l, gf_y_h;

  static int gi_zoom_flag = 0;
  static float gf_x_low_temp, gf_x_high_temp, gf_y_low_temp, gf_y_high_temp;
  static float gf_x_move, gf_y_move;
  static float gf_x_low_sav, gf_x_high_sav, gf_y_low_sav, gf_y_high_sav;

  extern int gi_D;
  extern int gi_NP;

  t_pop *gpta_pop;        //the two populations are put into one array side by side.
  extern t_pop *gpta_old, *gpta_new;

//-----Initialization of graphics-------------------------------------

void graphics_init(void)
/**C*F****************************************************************
**                                                                  
** SRC-FUNCTION   :void graphics_init()                                        
**                                                                  
** AUTHOR         :Rainer Storn                                     
**                                                                  
** DESCRIPTION    :-                 
**                                                                  
** FUNCTIONS      :-                                                
**                                                                  
** GLOBALS        :-                                                
**                                                                  
** PARAMETERS     :-   
**                                                                  
** PRECONDITIONS  :-                     
**                                                                  
** POSTCONDITIONS :none                                             
**                                                                  
***C*F*E*************************************************************/
{
  // define coordinate system
#ifdef SHOW_ROA
  gf_x_low  = -2;
  gf_x_high = +2;
  gf_y_low  = -2;
  gf_y_high = +2;
#else
  gf_x_low  = 0;
  gf_x_high = 20;
  gf_y_low  = 0;
  gf_y_high = 3;
#endif //SHOW_ROA

  gf_x_low_sav  = gf_x_low;
  gf_x_high_sav = gf_x_high;
  gf_y_low_sav  = gf_y_low;
  gf_y_high_sav = gf_y_high;

  axis(gf_x_low,gf_x_high,gf_y_low,gf_y_high); 

  gca_sbufi[0] = '\0';            // Initialize string buffer
  gca_sbufp[0] = '\0';            // Initialize string buffer
  gca_sbuft[0] = '\0';            // Initialize string buffer
}

void draw_graph(float fa_params[], char color)
/**C*F****************************************************************
**                                                                  
** SRC-FUNCTION   :void draw_graph()                                        
**                                                                  
** AUTHOR         :Rainer Storn                                     
**                                                                  
** DESCRIPTION    :-                 
**                                                                  
** FUNCTIONS      :-                                                
**                                                                  
** GLOBALS        :-                                                
**                                                                  
** PARAMETERS     :-   
**                                                                  
** PRECONDITIONS  :-                     
**                                                                  
** POSTCONDITIONS :none                                             
**                                                                  
***C*F*E*************************************************************/
{
   int i;

#ifdef SHOW_ROA
      for (i=0; i<gi_NP; i++)
	  {
		  fcircle(gpta_pop[i].fa_vector[0],gpta_pop[i].fa_vector[1],0.02,color);
	  }
#else
//------first point--------------------------------
		gf_xgo = gf_x_low;
		gf_ygraph = 0.0;
		gf_ygraph = 1.0/(1.0 + fa_params[0]*gf_xgo + fa_params[1]*gf_xgo*fa_params[1]*gf_xgo);

        if (gf_ygraph < gf_y_low)  gf_ygraph = gf_y_low;
        if (gf_ygraph > gf_y_high) gf_ygraph = gf_y_high;
		gf_ygo = gf_ygraph;

//------Compute remaining points.------------------

		for (i=1; i<=120; i++)
		{
		  gf_ygraph = 0.0;
		  gf_xgraph = ((float)i/120.0)*(gf_x_high - gf_x_low) + gf_x_low;
		  gf_ygraph = 1.0/(1.0 + fa_params[0]*gf_xgo + fa_params[1]*gf_xgo*fa_params[1]*gf_xgo);

		  if (gf_xgraph < gf_x_low)  gf_xgraph = gf_x_low;
		  if (gf_xgraph > gf_x_high) gf_xgraph = gf_x_high;
		  if (gf_ygraph < gf_y_low)  gf_ygraph = gf_y_low;
		  if (gf_ygraph > gf_y_high) gf_ygraph = gf_y_high;

		  fline(gf_xgo,gf_ygo,gf_xgraph,gf_ygraph,color);
		  gf_ygo = gf_ygraph;
		  gf_xgo = gf_xgraph;
		}
#endif //SHOW_ROA
}

void update_graphics(float best[], int gi_D, float gfa_bound[], long gl_nfeval, int gi_gen, float gf_emin, int i_strategy, int gi_genmax)
/**C*F****************************************************************
**                                                                  
** SRC-FUNCTION   :void update_graphics()                                        
**                                                                  
** AUTHOR         :Rainer Storn                                     
**                                                                  
** DESCRIPTION    :Graphics function for the design centering problem. Shows either
**                 the population moving towards the ROA or the function graph
**                 fitting the tolerance scheme.                 
**                                                                  
** Functions      :xflt(), yflt(), frect(), Cls(), axis(), draw_graph(), box(),
**                 grid(), fline(), sprintf(), myprint().                                                
**                                                                  
** Globals        :(see code)  
**                                                                  
** Parameters     :best[]        (I)    Parameter vector
**                 i_D           (I)    Dimension of the parameter vector  
**                 fa_bound[]    (I)    Array defining a tolerance scheme for the current example
**                 l_nfeval      (I)    Current number of acumulated function evaluations                                          
**                 i_gen         (I)    Current number of accumulated generations
**                 f_emin        (I)    Current best objective function value
**                 i_strategy    (I)    DE-strategy used (coded as a number)
**                 gi_genmax     (I)    Maximum number of generations   
**                                                                  
** PRECONDITIONS  :-                     
**                                                                  
** POSTCONDITIONS :none                                             
**                                                                  
***C*F*E*************************************************************/
{
	int i, j;
#ifdef SHOW_ROA
    float a,b,ce,hmax,hmin,hs,p1,p2,pmin,pmax,po1,po2; //variables for constrained region
#endif //SHOW_ROA

//======Zoom control================================================

	if ((MouseLp == TRUE) && (MouseL == TRUE) && (gi_zoom_flag == 0)) //if left mouse button has been pressed
	{
	   gf_x_low_temp  = xflt(MouseX);
	   gf_y_high_temp = yflt(MouseY);
	   gi_zoom_flag = 1;
	}
	if ((MouseLp == TRUE) && (MouseL == TRUE) && (gi_zoom_flag == 1)) //if left mouse button not yet pressed
    {
	   frect(gf_x_low_temp,gf_y_high_temp,gf_x_move,gf_y_move,'w');
	   gf_x_move = xflt(MouseX);
	   gf_y_move = yflt(MouseY);
	   if ((gf_x_move > gf_x_low_temp) && (gf_y_move < gf_y_high_temp))
	   {
	     frect(gf_x_low_temp,gf_y_high_temp,gf_x_move,gf_y_move,'s');
	   }
	}

	if ((MouseLp == TRUE) && (MouseL == FALSE) && (gi_zoom_flag == 1)) //if left mouse button has been pressed
	{
	   gf_x_high_temp = xflt(MouseX);
	   gf_y_low_temp  = yflt(MouseY);

	   if ((gf_x_high_temp >= gf_x_low_temp) &&
           (gf_y_high_temp >= gf_y_low_temp))
	   {
		   gf_x_low  = gf_x_low_temp;
		   gf_x_high = gf_x_high_temp;
		   gf_y_low  = gf_y_low_temp;
		   gf_y_high = gf_y_high_temp;

		   Cls();//clear screen
		   axis(gf_x_low,gf_x_high,gf_y_low,gf_y_high);
	   }
	   MouseLp == FALSE;
	   gi_zoom_flag = 0;
	}

	if ((MouseRp == TRUE) && (MouseR == FALSE))//right mouse button undoes zooming
	{
	  gf_x_low  = gf_x_low_sav;
	  gf_x_high = gf_x_high_sav;
	  gf_y_low  = gf_y_low_sav;
	  gf_y_high = gf_y_high_sav;
	  Cls();//clear screen
	  axis(gf_x_low,gf_x_high,gf_y_low,gf_y_high);
      MouseRp = FALSE;
	}


	
//======Remove previous graph.============================
//------We do this simply by repainting in white.---------
	    gpta_pop = gpta_new; //new population
        draw_graph(gfa_xmold,'w');

//======Begin with the new drawings.==================================
//------draw surrounding box------------------------------------------
		box('y');//grey box

//-----draw grid------------------------------------------------------
#ifdef SHOW_ROA
        grid('y',4,4);
#else
	    grid('y',5,5);
#endif //SHOW_ROA
//-----draw tolerance scheme--------------------------------------------
#ifdef SHOW_ROA
	  hmax = MAXUP1;
	  hs   = MAXUP2;
	  hmin = MAXLOW;
      a    = 2.*sqrt(1.-1/hmax);
      b    = 0.2*((1./hmin)-1.);
      ce   = 0.1*((1./hs)-1.);

      pmin = -0.1* (a+sqrt(a*a+20.*b));
      pmax = -0.05*(a+sqrt(a*a+40.*ce));
      po2  = pmin;
      po1  = a*po2;
      for(i=1; i<=100; i++)
      {
		p2   = pmin + (pmax-pmin)*(float)i*0.01;
		p1   = a*p2;
		fline(po1,po2,p1,p2,'b');
		po1  = p1;
		po2  = p2;
      }

      pmax = 0.1* (a+sqrt(a*a+20.*b));
      pmin = 0.05*(a+sqrt(a*a+40.*ce));
      po2  = pmin;
      po1  = -a*po2;
      for(i=1; i<=100; i++)
      {
		p2   = pmin + (pmax-pmin)*(float)i*0.01;
		p1   = -a*p2;
		fline(po1,po2,p1,p2,'b');
		po1  = p1;
		po2  = p2;
      }

      pmin = -0.1* (a+sqrt(a*a+20.*b));   //outer parabola
      pmax =  0.1* (a+sqrt(a*a+20.*b));
      po2  = pmin;
      po1  = b - 5.*po2*po2;
      for(i=1; i<=100; i++)
      {
		p2   = pmin + (pmax-pmin)*(float)i*0.01;
		p1   = b - 5.*p2*p2;
		fline(po1,po2,p1,p2,'b');
		po1  = p1;
		po2  = p2;
      }

      pmin = -0.05*(a+sqrt(a*a+40.*ce));  //inner parabola
      pmax = 0.05*(a+sqrt(a*a+40.*ce));
      po2  = pmin;
      po1  = ce - 10.*po2*po2;
      for(i=1; i<=100; i++)
      {
		p2   = pmin + (pmax-pmin)*(float)i*0.01;
		p1   = ce - 10.*p2*p2;
		fline(po1,po2,p1,p2,'b');
		po1  = p1;
		po2  = p2;
      }


#else
		fline(0,MAXUP1,10,MAXUP1,'b'); 
		fline(10,MAXUP1,10.01,MAXUP2,'b');
		fline(10.01,MAXUP2,20,MAXUP2,'b'); 
		fline(0,MAXLOW,5,MAXLOW,'b'); 
		fline(5.01,MAXLOW,5.01,0,'b'); 
#endif //SHOW_ROA

//------Draw new polynomial----------------------------------------------
	    gpta_pop = gpta_old;//old population
        draw_graph(best,'r');

//----Save old polynomial so that it can be erased later------------------

		for (j=0; j<gi_D; j++)
		{
		  gfa_xmold[j] = best[j];
		}

//------Display current number of trials----------------------------------
// x-positioning (gf_x_low + k*(gf_x_high - gf_x_low))

		 sprintf(gca_sbuft,"No. of trials:  %ld",gl_nfeval);
		 myprint((gf_x_low + 0*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

//------Display current Iteration-----------------------------------------
		 sprintf(gca_sbufi,"Iteration:       %d",gi_gen);
		 myprint((gf_x_low + 0.3*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbufi);

//------Display current pathlength----------------------------------------
		 sprintf(gca_sbufp,"best OFUNC value: %-11.10g",gf_emin);
		 myprint((gf_x_low + 0.5*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbufp);

//------Display author name-----------------------------------------------
		 myprint((gf_x_low + 0.9*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),"Author: Rainer Storn");

}