/*
Trusster Open Source License version 1.0a (TRUST)
copyright (c) 2006 Mike Mintz and Robert Ekendahl.  All rights reserved. 

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met: 
   
  * Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.
  * Redistributions in any form must be accompanied by information on how to obtain 
    complete source code for this software and any accompanying software that uses this software.
    The source code must either be included in the distribution or be available in a timely fashion for no more than 
    the cost of distribution plus a nominal fee, and must be freely redistributable under reasonable and no more 
    restrictive conditions. For an executable file, complete source code means the source code for all modules it 
    contains. It does not include source code for modules or files that typically accompany the major components 
    of the operating system on which the executable file runs.
 

THIS SOFTWARE IS PROVIDED BY MIKE MINTZ AND ROBERT EKENDAHL ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, 
OR NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL MIKE MINTZ AND ROBERT EKENDAHL OR ITS CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __uart_basic_test_component__
#define __uart_basic_test_component__

#include "uart_bfm.h"
#include "uart_generator.h"
#include "uart_checker.h"

#include "truss.h"

//simple fixed form, run n bytes through a uart
//The following teal::dictionary control knows are used. All the prefixed with the name of the generator.
// _min_num_words, _max_num_words  
//_min_block_delay, _max_block_delay

//see uart::basic_irretator for an infinate run irretator form

namespace uart {
  class basic_test_component : public virtual truss::test_component {
  public:
    basic_test_component (const std::string& n, generator* g, verification_component* b, checker* c);

    virtual void randomize ();

    virtual void time_zero_setup () { bfm_->time_zero_setup ();};

    virtual void out_of_reset (reset r) {bfm_->out_of_reset (r);};

    virtual void write_to_hardware () {bfm_->write_to_hardware ();}

  protected:
    virtual void generate ();
    virtual void wait_for_completion_ ();
    virtual void start_components_ ();

    uart::generator* generator_;
    truss::verification_component*       bfm_; 
    uart::checker*   checker_;

    /*rand*/ teal::uint32 block_size_;
    /*rand*/ teal::uint32 block_delay_;
  };

};

#endif
