/*
 * Copyright (c) 2004 Mike Mintz (mike@applevalleysoftware.com)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

`timescale 1 ps / 1 ps

module top;
   reg       [122:0]  bank0  [0 : 15]; 
   integer index;
   initial
      begin
	 $write ("[%0t ns] mem_test.v: %m initing RAM.\n", $time);
	 index = 0;
	 while (index <= 15) begin
	    bank0[index] = 123'h0;
	    index = index + 1;
	 end
	 $write ("[%0t ns] mem_test.v: %m initing RAM done. \n", $time);     
      end

   initial $teal_memory_note (bank0);


   reg init_done;
   initial begin
      init_done = 0; 
      init_done = #1 1;
   end
   initial 
      begin
	 $teal_top;
      end 
   


   reg[3:0] mem_index;
   
   reg check_data;
   reg get_data;
    initial
      begin
	 get_data = 1;
	 check_data = 0;
	 mem_index = 0;
      end
   always
      begin
	#20;
	 get_data <= !get_data;
      end

   reg [122:0] data_value;
   
   always @(posedge (get_data))
      begin
	if (init_done) begin
	 bank0[mem_index] <= data_value;
	//	 $display ("[%0t ns] Verilog: set memory at index %d to %h, confirm %h", $time, mem_index, data_value, bank0[mem_index]);
	 mem_index <= mem_index + 1;
	 check_data <= (mem_index == 15) ? 1 : 0;
	end
      end
   

   reg test_done;
   initial begin
      test_done = 0; 
      @ (posedge (test_done));
      $display ("[%0t ns] VERILOG: Received exit from Teal. Exiting simulation.", $time);
      $finish ();
   end

   

   //Usually, its teal that decides when to quit. But this test is so simple,
   //I could not come up with a plausable "when".
   reg simple_test_done;
   initial begin
      simple_test_done = 0;
      #84000;
      $display ("[%0t ns] VERILOG: Requesting that Teal exit.", $time);
      simple_test_done = 1;
   end
   
   
endmodule 
