IC-Emit 1.2e
VERSION 10/02/2005 16:26:38
BB(95,-36,505,129)
SYM  #Cdpi
BB(445,-30,455,-10)
TITLE 455 -25  #C
MODEL 900
PROP   6n                                                                                                                                 
REC(155,0,0,0,g)
VIS 6
PIN(450,-30,1.0,1.0)c1
PIN(450,-10,1.0,1.0)c2
LIG(450,-21,450,-30)
LIG(445,-21,455,-21)
LIG(445,-19,455,-19)
LIG(450,-10,450,-19)
AMS ENTITY capacitor is 
AMS    GENERIC(C : real := 1e-12); 
AMS    PORT (terminal n1, n2 : electrical);
AMS END ENTITY capacitor;
AMS 
AMS ARCHITECTURE capacitor_model of capacitor is 
AMS   QUANTITY capacitor_u across n1 to n2; 
AMS   QUANTITY capacitor_i through n1 to n2;
AMS BEGIN
AMS    capacitor_i == C * capacitor_u'dot;
AMS END ARCHITECTURE capacitor_model;
FSYM
SYM  #box1
BB(200,10,220,80)
TITLE 201 11  #TemBoard
MODEL 947
PROP   20 70                                                                                                                                
REC(290,-70,0,0, )
VIS 4
LIG(200,10,202,10)
LIG(200,80,202,80)
LIG(204,10,206,10)
LIG(204,80,206,80)
LIG(208,10,210,10)
LIG(208,80,210,80)
LIG(212,10,214,10)
LIG(212,80,214,80)
LIG(216,10,218,10)
LIG(216,80,218,80)
LIG(200,10,200,12)
LIG(220,10,220,12)
LIG(200,14,200,16)
LIG(220,14,220,16)
LIG(200,18,200,20)
LIG(220,18,220,20)
LIG(200,22,200,24)
LIG(220,22,220,24)
LIG(200,26,200,28)
LIG(220,26,220,28)
LIG(200,30,200,32)
LIG(220,30,220,32)
LIG(200,34,200,36)
LIG(220,34,220,36)
LIG(200,38,200,40)
LIG(220,38,220,40)
LIG(200,42,200,44)
LIG(220,42,220,44)
LIG(200,46,200,48)
LIG(220,46,220,48)
LIG(200,50,200,52)
LIG(220,50,220,52)
LIG(200,54,200,56)
LIG(220,54,220,56)
LIG(200,58,200,60)
LIG(220,58,220,60)
LIG(200,62,200,64)
LIG(220,62,220,64)
LIG(200,66,200,68)
LIG(220,66,220,68)
LIG(200,70,200,72)
LIG(220,70,220,72)
LIG(200,74,200,76)
LIG(220,74,220,76)
FSYM
SYM  #vss
BB(95,-3,105,5)
TITLE 99 2  #vss
MODEL 0
PROP                                                                                                                                    
REC(95,-5,0,0,b)
VIS 0
PIN(100,-5,1.0,1.0)vss
LIG(100,-5,100,0)
LIG(95,0,105,0)
LIG(95,3,97,0)
LIG(97,3,99,0)
LIG(99,3,101,0)
LIG(101,3,103,0)
FSYM
SYM  #VRFI
BB(95,-30,105,-5)
TITLE 100 -18  #V
MODEL 965
PROP   2.5 1 0 1.0 0.1 0.1 1.0 2.0 0                                                                                                                        
REC(0,0,0,0,g)
VIS 2
PIN(100,-30,1.0,1.0)Vp
PIN(100,-5,1.0,1.0)Vm
LIG(100,-5,100,-10)
LIG(100,-30,100,-25)
LIG(95,-20,95,-15)
LIG(105,-20,105,-15)
LIG(95,-15,100,-10)
LIG(105,-15,100,-10)
LIG(105,-20,100,-25)
LIG(95,-20,100,-25)
LIG(98,-20,102,-20)
LIG(100,-22,100,-18)
LIG(98,-15,102,-15)
AMS LIBRARY IEEE;
AMS   USE IEEE.ELECTRICAL_SYSTEMS.ALL;
AMS 
AMS ENTITY Vsource IS
AMS  GENERIC(
AMS          VLOW : real := 0.0;      -- low value
AMS          VHIGH : real := 2.0;     -- high value
AMS          TRISE : real := 1e-9;    -- rise time
AMS          TFALL : real := 1e-9;    -- fall time
AMS          TD    : time := 0.0 ns;  -- initial delay
AMS          PWIDTH: time := 1.0 ns); -- pulse width
AMS  PORT (clkp,clkm : electrical);
AMS END ENTITY Vsource;
AMS 
AMS 
AMS ARCHITECTURE Vsource_Model OF Vsource IS
AMS 
AMS QUANTITY vsource ACROSS iclock THROUGH clkp TO clkm;
AMS SIGNAL spulse : REAL = VLOW; -- the internal signal
AMS 
AMS 
AMS BEGIN
AMS   PROCESS
AMS   BEGIN
AMS      WAIT for TD; -- nothing before initial delay
AMS      LOOP
AMS        spulse <= VHIGH;
AMS        WAIT FOR PWIDTH;
AMS        spulse <=VLOW;
AMS        WAIT FOR PWIDTH;
AMS      END LOOP;
AMS   END PROCESS;
AMS   vsource == spulse'ramp(TRISE,TFALL);
AMS END ARCHITECTURE Vsource_Model;
FSYM
SYM  #vss2
BB(495,47,505,55)
TITLE 499 52  #vss
MODEL 0
PROP                                                                                                                                    
REC(495,45,0,0,b)
VIS 0
PIN(500,45,1.0,1.0)vss
LIG(500,45,500,50)
LIG(495,50,505,50)
LIG(495,53,497,50)
LIG(497,53,499,50)
LIG(499,53,501,50)
LIG(501,53,503,50)
FSYM
SYM  #LVss_die
BB(295,34,315,46)
TITLE 305 25  #Lvss_die
MODEL 930
PROP   2n                                                                                                                                 
REC(265,20,0,0,)
VIS 2
PIN(295,40,1.0,1.0)l1
PIN(315,40,1.0,1.0)l2
LIG(297,40,295,40)
LIG(311,37,312,40)
LIG(310,36,311,37)
LIG(309,36,310,36)
LIG(308,37,309,36)
LIG(307,40,308,37)
LIG(306,37,307,40)
LIG(305,36,306,37)
LIG(304,36,305,36)
LIG(303,37,304,36)
LIG(302,40,303,37)
LIG(301,37,302,40)
LIG(300,36,301,37)
LIG(299,36,300,36)
LIG(298,37,299,36)
LIG(297,40,298,37)
LIG(312,40,315,40)
FSYM
SYM  #vss1
BB(210,-23,220,-15)
TITLE 214 -18  #vss
MODEL 0
PROP                                                                                                                                    
REC(210,-25,0,0,b)
VIS 0
PIN(215,-25,1.0,1.0)vss
LIG(215,-25,215,-20)
LIG(210,-20,220,-20)
LIG(210,-17,212,-20)
LIG(212,-17,214,-20)
LIG(214,-17,216,-20)
LIG(216,-17,218,-20)
FSYM
SYM  #vss6
BB(365,42,375,50)
TITLE 369 47  #vss
MODEL 0
PROP                                                                                                                                    
REC(365,40,0,0,b)
VIS 0
PIN(370,40,1.0,1.0)vss
LIG(370,40,370,45)
LIG(365,45,375,45)
LIG(365,48,367,45)
LIG(367,48,369,45)
LIG(369,48,371,45)
LIG(371,48,373,45)
FSYM
SYM  #Lvdd_die
BB(295,-1,315,11)
TITLE 305 -10  #Lvdd_die
MODEL 930
PROP   2n                                                                                                                                 
REC(265,-15,0,0,)
VIS 2
PIN(295,5,1.0,1.0)l1
PIN(315,5,1.0,1.0)l2
LIG(297,5,295,5)
LIG(311,2,312,5)
LIG(310,1,311,2)
LIG(309,1,310,1)
LIG(308,2,309,1)
LIG(307,5,308,2)
LIG(306,2,307,5)
LIG(305,1,306,2)
LIG(304,1,305,1)
LIG(303,2,304,1)
LIG(302,5,303,2)
LIG(301,2,302,5)
LIG(300,1,301,2)
LIG(299,1,300,1)
LIG(298,2,299,1)
LIG(297,5,298,2)
LIG(312,5,315,5)
FSYM
SYM  #Cd
BB(290,10,300,30)
TITLE 300 15  #Cb
MODEL 900
PROP   3n                                                                                                                                 
REC(305,-35,0,0,)
VIS 2
PIN(295,10,1.0,1.0)c1
PIN(295,30,1.0,1.0)c2
LIG(295,19,295,10)
LIG(290,19,300,19)
LIG(290,21,300,21)
LIG(295,30,295,21)
FSYM
SYM  #R8
BB(395,20,405,40)
TITLE 400 30  #R
MODEL 920
PROP   500                                                                                                                                
REC(265,435,0,0,g)
VIS 6
PIN(400,40,1.0,1.0)r1
PIN(400,20,1.0,1.0)r2
LIG(400,40,400,36)
LIG(398,34,400,36)
LIG(402,32,398,34)
LIG(398,29,402,32)
LIG(402,27,398,29)
LIG(398,24,402,27)
LIG(400,23,398,24)
LIG(400,20,400,23)
AMS ENTITY resistor is
AMS    GENERIC(R : real := 1e-3);
AMS    PORT (terminal n1, n2 : electrical);
AMS END ENTITY resistor;
AMS 
AMS ARCHITECTURE resistor_model of capacitor is
AMS   QUANTITY resistor_u across n1 to n2;
AMS   QUANTITY resistor_i through n1 to n2;
AMS BEGIN
AMS    resistor_i == resistor_i/R;
AMS END ARCHITECTURE resistor_model;
FSYM
SYM  #Rstabilize
BB(350,35,370,45)
TITLE 360 40  #R10
MODEL 920
PROP   1000                                                                                                                                 
REC(275,-40,0,0, )
VIS 2
PIN(350,40,1.0,1.0)r1
PIN(370,40,1.0,1.0)r2
LIG(350,40,354,40)
LIG(356,38,354,40)
LIG(358,42,356,38)
LIG(361,38,358,42)
LIG(363,42,361,38)
LIG(366,38,363,42)
LIG(367,40,366,38)
LIG(370,40,367,40)
FSYM
SYM  #Lvss
BB(250,34,270,46)
TITLE 260 40  #Lvss
MODEL 930
PROP   6n                                                                                                                                 
REC(220,20,0,0,)
VIS 2
PIN(250,40,1.0,1.0)l1
PIN(270,40,1.0,1.0)l2
LIG(252,40,250,40)
LIG(266,37,267,40)
LIG(265,36,266,37)
LIG(264,36,265,36)
LIG(263,37,264,36)
LIG(262,40,263,37)
LIG(261,37,262,40)
LIG(260,36,261,37)
LIG(259,36,260,36)
LIG(258,37,259,36)
LIG(257,40,258,37)
LIG(256,37,257,40)
LIG(255,36,256,37)
LIG(254,36,255,36)
LIG(253,37,254,36)
LIG(252,40,253,37)
LIG(267,40,270,40)
FSYM
SYM  #Cd1
BB(345,10,355,30)
TITLE 355 15  #Cd
MODEL 900
PROP   100p                                                                                                                                 
REC(305,-30,0,0,)
VIS 2
PIN(350,10,1.0,1.0)c1
PIN(350,30,1.0,1.0)c2
LIG(350,19,350,10)
LIG(345,19,355,19)
LIG(345,21,355,21)
LIG(350,30,350,21)
FSYM
SYM  #Rvss_die
BB(315,35,335,45)
TITLE 325 25  #Rvss_die
MODEL 920
PROP   3                                                                                                                                 
REC(350,20,0,0,)
VIS 2
PIN(315,40,1.0,1.0)r1
PIN(335,40,1.0,1.0)r2
LIG(315,40,319,40)
LIG(321,38,319,40)
LIG(323,42,321,38)
LIG(326,38,323,42)
LIG(328,42,326,38)
LIG(331,38,328,42)
LIG(332,40,331,38)
LIG(335,40,332,40)
FSYM
SYM  #Rvde
BB(245,70,255,90)
TITLE 250 80  #Rvde
MODEL 920
PROP   1                                                                                                                                 
REC(335,35,0,0,)
VIS 2
PIN(250,70,1.0,1.0)r1
PIN(250,90,1.0,1.0)r2
LIG(250,70,250,74)
LIG(252,76,250,74)
LIG(248,78,252,76)
LIG(252,81,248,78)
LIG(248,83,252,81)
LIG(252,86,248,83)
LIG(250,87,252,86)
LIG(250,90,250,87)
FSYM
SYM  #vss3
BB(245,92,255,100)
TITLE 249 97  #vss
MODEL 0
PROP                                                                                                                                    
REC(245,90,0,0,b)
VIS 0
PIN(250,90,1.0,1.0)vss
LIG(250,90,250,95)
LIG(245,95,255,95)
LIG(245,98,247,95)
LIG(247,98,249,95)
LIG(249,98,251,95)
LIG(251,98,253,95)
FSYM
SYM  #Rvdd_die
BB(315,0,335,10)
TITLE 325 -8  #Rvdd_die
MODEL 920
PROP   3                                                                                                                                 
REC(350,-15,0,0,)
VIS 2
PIN(315,5,1.0,1.0)r1
PIN(335,5,1.0,1.0)r2
LIG(315,5,319,5)
LIG(321,3,319,5)
LIG(323,7,321,3)
LIG(326,3,323,7)
LIG(328,7,326,3)
LIG(331,3,328,7)
LIG(332,5,331,3)
LIG(335,5,332,5)
FSYM
SYM  #Lvdd
BB(250,-1,270,11)
TITLE 260 5  #Lvdd
MODEL 930
PROP   6n                                                                                                                                 
REC(220,-15,0,0,)
VIS 2
PIN(250,5,1.0,1.0)l1
PIN(270,5,1.0,1.0)l2
LIG(252,5,250,5)
LIG(266,2,267,5)
LIG(265,1,266,2)
LIG(264,1,265,1)
LIG(263,2,264,1)
LIG(262,5,263,2)
LIG(261,2,262,5)
LIG(260,1,261,2)
LIG(259,1,260,1)
LIG(258,2,259,1)
LIG(257,5,258,2)
LIG(256,2,257,5)
LIG(255,1,256,2)
LIG(254,1,255,1)
LIG(253,2,254,1)
LIG(252,5,253,2)
LIG(267,5,270,5)
FSYM
SYM  #I2
BB(330,10,340,35)
TITLE 337 22  #I2
MODEL 960
PROP   100mA 0 0 1.0 1 1 0.1 50 1                                                                                                                         
REC(360,-35,0,0,)
VIS 2
PIN(335,10,1.0,1.0)Im
PIN(335,35,1.0,1.0)Ip
LIG(335,35,335,30)
LIG(335,10,335,15)
LIG(330,20,335,15)
LIG(340,20,335,15)
LIG(330,20,335,25)
LIG(340,20,335,25)
LIG(330,25,335,20)
LIG(340,25,335,20)
LIG(330,25,335,30)
LIG(340,25,335,30)
LIG(335,18,335,27)
LIG(334,26,335,27)
LIG(335,27,336,26)
FSYM
SYM  #Cpcb
BB(205,55,215,75)
TITLE 215 60  #Cpcb
MODEL 900
PROP   90pF                                                                                                                                 
REC(185,10,0,0, )
VIS 2
PIN(210,55,1.0,1.0)c1
PIN(210,75,1.0,1.0)c2
LIG(210,64,210,55)
LIG(205,64,215,64)
LIG(205,66,215,66)
LIG(210,75,210,66)
FSYM
SYM  #Lpcb
BB(204,35,216,55)
TITLE 210 45  #Lpcb
MODEL 930
PROP   0.15nH                                                                                                                                 
REC(205,60,0,0, )
VIS 2
PIN(210,55,1.0,1.0)l1
PIN(210,35,1.0,1.0)l2
LIG(210,53,210,55)
LIG(207,39,210,38)
LIG(206,40,207,39)
LIG(206,41,206,40)
LIG(207,42,206,41)
LIG(210,43,207,42)
LIG(207,44,210,43)
LIG(206,45,207,44)
LIG(206,46,206,45)
LIG(207,47,206,46)
LIG(210,48,207,47)
LIG(207,49,210,48)
LIG(206,50,207,49)
LIG(206,51,206,50)
LIG(207,52,206,51)
LIG(210,53,207,52)
LIG(210,38,210,35)
FSYM
SYM  #Rprotect
BB(465,15,485,25)
TITLE 475 20  #R
MODEL 920
PROP   470                                                                                                                                 
REC(0,0,0,0, )
VIS 6
PIN(465,20,1.0,1.0)r1
PIN(485,20,1.0,1.0)r2
LIG(465,20,469,20)
LIG(471,18,469,20)
LIG(473,22,471,18)
LIG(476,18,473,22)
LIG(478,22,476,18)
LIG(481,18,478,22)
LIG(482,20,481,18)
LIG(485,20,482,20)
AMS ENTITY resistor is
AMS    GENERIC(R : real := 1e-3);
AMS    PORT (terminal n1, n2 : electrical);
AMS END ENTITY resistor;
AMS 
AMS ARCHITECTURE resistor_model of capacitor is
AMS   QUANTITY resistor_u across n1 to n2;
AMS   QUANTITY resistor_i through n1 to n2;
AMS BEGIN
AMS    resistor_i == resistor_i/R;
AMS END ARCHITECTURE resistor_model;
FSYM
SYM  #Cio_load
BB(495,25,505,45)
TITLE 505 30  #C
MODEL 900
PROP   10p                                                                                                                                 
REC(0,0,0,0, )
VIS 6
PIN(500,25,1.0,1.0)c1
PIN(500,45,1.0,1.0)c2
LIG(500,34,500,25)
LIG(495,34,505,34)
LIG(495,36,505,36)
LIG(500,45,500,36)
AMS ENTITY capacitor is 
AMS    GENERIC(C : real := 1e-12); 
AMS    PORT (terminal n1, n2 : electrical);
AMS END ENTITY capacitor;
AMS 
AMS ARCHITECTURE capacitor_model of capacitor is 
AMS   QUANTITY capacitor_u across n1 to n2; 
AMS   QUANTITY capacitor_i through n1 to n2;
AMS BEGIN
AMS    capacitor_i == C * capacitor_u'dot;
AMS END ARCHITECTURE capacitor_model;
FSYM
SYM  #Rpcb
BB(205,15,215,35)
TITLE 210 25  #Rpcb
MODEL 920
PROP   0.12                                                                                                                                 
REC(205,60,0,0, )
VIS 2
PIN(210,35,1.0,1.0)r1
PIN(210,15,1.0,1.0)r2
LIG(210,35,210,31)
LIG(208,29,210,31)
LIG(212,27,208,29)
LIG(208,24,212,27)
LIG(212,22,208,24)
LIG(208,19,212,22)
LIG(210,18,208,19)
LIG(210,15,210,18)
FSYM
SYM  #vss4
BB(205,92,215,100)
TITLE 209 97  #vss
MODEL 0
PROP                                                                                                                                    
REC(205,90,0,0,b)
VIS 0
PIN(210,90,1.0,1.0)vss
LIG(210,90,210,95)
LIG(205,95,215,95)
LIG(205,98,207,95)
LIG(207,98,209,95)
LIG(209,98,211,95)
LIG(211,98,213,95)
FSYM
SYM  #Lio
BB(430,14,450,26)
TITLE 440 20  #L
MODEL 930
PROP   6n                                                                                                                                 
REC(0,0,0,0, )
VIS 6
PIN(430,20,1.0,1.0)l1
PIN(450,20,1.0,1.0)l2
LIG(432,20,430,20)
LIG(446,17,447,20)
LIG(445,16,446,17)
LIG(444,16,445,16)
LIG(443,17,444,16)
LIG(442,20,443,17)
LIG(441,17,442,20)
LIG(440,16,441,17)
LIG(439,16,440,16)
LIG(438,17,439,16)
LIG(437,20,438,17)
LIG(436,17,437,20)
LIG(435,16,436,17)
LIG(434,16,435,16)
LIG(433,17,434,16)
LIG(432,20,433,17)
LIG(447,20,450,20)
AMS ENTITY Inductor IS
AMS   GENERIC (L : real := 1.0e-6);
AMS   PORT (TERMINAL p,n : electrical);
AMS END ENTITY Inductor;
AMS 
AMS ARCHITECTURE Inductor_model OF Inductor IS
AMS   QUANTITY Vl ACROSS Il THROUGH p TO n;
AMS BEGIN
AMS   Vl == L * Il'dot;
AMS END ARCHITECTURE Inductor_model;
FSYM
SYM  #Cio
BB(420,20,430,40)
TITLE 430 25  #C
MODEL 900
PROP   1p                                                                                                                                 
REC(0,0,0,0, )
VIS 6
PIN(425,20,1.0,1.0)c1
PIN(425,40,1.0,1.0)c2
LIG(425,29,425,20)
LIG(420,29,430,29)
LIG(420,31,430,31)
LIG(425,40,425,31)
AMS ENTITY capacitor is 
AMS    GENERIC(C : real := 1e-12); 
AMS    PORT (terminal n1, n2 : electrical);
AMS END ENTITY capacitor;
AMS 
AMS ARCHITECTURE capacitor_model of capacitor is 
AMS   QUANTITY capacitor_u across n1 to n2; 
AMS   QUANTITY capacitor_i through n1 to n2;
AMS BEGIN
AMS    capacitor_i == C * capacitor_u'dot;
AMS END ARCHITECTURE capacitor_model;
FSYM
SYM  #probe
BB(310,58,320,71)
TITLE 310 62  #Vout
MODEL 938
PROP   1                                                                                                                                 
REC(50,0,0,0,g)
VIS 4
PIN(310,70,1.0,1.0)in
LIG(310,70,314,66)
LIG(310,70,311,68)
LIG(310,70,312,69)
LIG(310,70,314,66)
LIG(314,66,314,58)
LIG(314,58,322,58)
LIG(314,66,322,66)
LIG(322,66,322,58)
LIG(318,65,320,60)
LIG(316,60,318,65)
FSYM
SYM  #tline
BB(145,-35,195,-25)
TITLE 160 -30  #tl
MODEL 932
PROP   50 3                                                                                                                                
REC(0,0,0,0, )
VIS 2
PIN(145,-30,1.0,1.0)p1
PIN(145,-25,1.0,1.0)p2
PIN(195,-30,1.0,1.0)p3
PIN(195,-25,1.0,1.0)p4
LIG(145,-30,152,-30)
LIG(195,-30,190,-30)
LIG(188,-25,195,-25)
LIG(188,-27,188,-25)
LIG(152,-33,188,-33)
LIG(152,-25,152,-27)
LIG(145,-25,152,-25)
LIG(189,-32,190,-30)
LIG(188,-33,189,-32)
LIG(152,-27,188,-27)
LIG(153,-33,154,-32)
LIG(154,-32,155,-30)
LIG(150,-30,151,-28)
LIG(151,-28,152,-27)
LIG(189,-28,190,-30)
LIG(153,-27,154,-28)
LIG(154,-28,155,-30)
LIG(150,-30,151,-32)
LIG(151,-32,152,-33)
LIG(188,-27,189,-28)
FSYM
SYM  #R10
BB(395,55,405,75)
TITLE 400 65  #R
MODEL 920
PROP   10K                                                                                                                                
REC(320,500,0,0,g)
VIS 6
PIN(400,75,1.0,1.0)r1
PIN(400,55,1.0,1.0)r2
LIG(400,75,400,71)
LIG(398,69,400,71)
LIG(402,67,398,69)
LIG(398,64,402,67)
LIG(402,62,398,64)
LIG(398,59,402,62)
LIG(400,58,398,59)
LIG(400,55,400,58)
AMS ENTITY resistor is
AMS    GENERIC(R : real := 1e-3);
AMS    PORT (terminal n1, n2 : electrical);
AMS END ENTITY resistor;
AMS 
AMS ARCHITECTURE resistor_model of capacitor is
AMS   QUANTITY resistor_u across n1 to n2;
AMS   QUANTITY resistor_i through n1 to n2;
AMS BEGIN
AMS    resistor_i == resistor_i/R;
AMS END ARCHITECTURE resistor_model;
FSYM
SYM  #vss5
BB(395,77,405,85)
TITLE 399 82  #vss
MODEL 0
PROP                                                                                                                                    
REC(395,75,0,0,b)
VIS 0
PIN(400,75,1.0,1.0)vss
LIG(400,75,400,80)
LIG(395,80,405,80)
LIG(395,83,397,80)
LIG(397,83,399,80)
LIG(399,83,401,80)
LIG(401,83,403,80)
FSYM
SYM  #V6
BB(175,10,185,35)
TITLE 180 22  #V
MODEL 965
PROP   2.5 1 0 1.0 0.1 0.1 1.0 2.0                                                                                                                         
REC(0,0,0,0, )
VIS 2
PIN(180,10,1.0,1.0)Vp
PIN(180,35,1.0,1.0)Vm
LIG(180,35,180,30)
LIG(180,10,180,15)
LIG(175,20,175,25)
LIG(185,20,185,25)
LIG(175,25,180,30)
LIG(185,25,180,30)
LIG(185,20,180,15)
LIG(175,20,180,15)
LIG(178,20,182,20)
LIG(180,18,180,22)
LIG(178,25,182,25)
AMS LIBRARY IEEE;
AMS   USE IEEE.ELECTRICAL_SYSTEMS.ALL;
AMS 
AMS ENTITY Vsource IS
AMS  GENERIC(
AMS          VLOW : real := 0.0;      -- low value
AMS          VHIGH : real := 2.0;     -- high value
AMS          TRISE : real := 1e-9;    -- rise time
AMS          TFALL : real := 1e-9;    -- fall time
AMS          TD    : time := 0.0 ns;  -- initial delay
AMS          PWIDTH: time := 1.0 ns); -- pulse width
AMS  PORT (clkp,clkm : electrical);
AMS END ENTITY Vsource;
AMS 
AMS 
AMS ARCHITECTURE Vsource_Model OF Vsource IS
AMS 
AMS QUANTITY vsource ACROSS iclock THROUGH clkp TO clkm;
AMS SIGNAL spulse : REAL = VLOW; -- the internal signal
AMS 
AMS 
AMS BEGIN
AMS   PROCESS
AMS   BEGIN
AMS      WAIT for TD; -- nothing before initial delay
AMS      LOOP
AMS        spulse <= VHIGH;
AMS        WAIT FOR PWIDTH;
AMS        spulse <=VLOW;
AMS        WAIT FOR PWIDTH;
AMS      END LOOP;
AMS   END PROCESS;
AMS   vsource == spulse'ramp(TRISE,TFALL);
AMS END ARCHITECTURE Vsource_Model;
FSYM
SYM  #vss7
BB(175,92,185,100)
TITLE 179 97  #vss
MODEL 0
PROP                                                                                                                                    
REC(175,90,0,0,b)
VIS 0
PIN(180,90,1.0,1.0)vss
LIG(180,90,180,95)
LIG(175,95,185,95)
LIG(175,98,177,95)
LIG(177,98,179,95)
LIG(179,98,181,95)
LIG(181,98,183,95)
FSYM
SYM  #Lrfi
BB(395,-36,415,-24)
TITLE 405 -30  #L
MODEL 930
PROP   2n                                                                                                                                
REC(0,0,0,0,g)
VIS 6
PIN(395,-30,1.0,1.0)l1
PIN(415,-30,1.0,1.0)l2
LIG(397,-30,395,-30)
LIG(411,-33,412,-30)
LIG(410,-34,411,-33)
LIG(409,-34,410,-34)
LIG(408,-33,409,-34)
LIG(407,-30,408,-33)
LIG(406,-33,407,-30)
LIG(405,-34,406,-33)
LIG(404,-34,405,-34)
LIG(403,-33,404,-34)
LIG(402,-30,403,-33)
LIG(401,-33,402,-30)
LIG(400,-34,401,-33)
LIG(399,-34,400,-34)
LIG(398,-33,399,-34)
LIG(397,-30,398,-33)
LIG(412,-30,415,-30)
AMS ENTITY Inductor IS
AMS   GENERIC (L : real := 1.0e-6);
AMS   PORT (TERMINAL p,n : electrical);
AMS END ENTITY Inductor;
AMS 
AMS ARCHITECTURE Inductor_model OF Inductor IS
AMS   QUANTITY Vl ACROSS Il THROUGH p TO n;
AMS BEGIN
AMS   Vl == L * Il'dot;
AMS END ARCHITECTURE Inductor_model;
FSYM
SYM  #Rrfi
BB(415,-35,435,-25)
TITLE 425 -30  #R
MODEL 920
PROP   1                                                                                                                                
REC(0,0,0,0,g)
VIS 6
PIN(415,-30,1.0,1.0)r1
PIN(435,-30,1.0,1.0)r2
LIG(415,-30,419,-30)
LIG(421,-32,419,-30)
LIG(423,-28,421,-32)
LIG(426,-32,423,-28)
LIG(428,-28,426,-32)
LIG(431,-32,428,-28)
LIG(432,-30,431,-32)
LIG(435,-30,432,-30)
AMS ENTITY resistor is
AMS    GENERIC(R : real := 1e-3);
AMS    PORT (terminal n1, n2 : electrical);
AMS END ENTITY resistor;
AMS 
AMS ARCHITECTURE resistor_model of capacitor is
AMS   QUANTITY resistor_u across n1 to n2;
AMS   QUANTITY resistor_i through n1 to n2;
AMS BEGIN
AMS    resistor_i == resistor_i/R;
AMS END ARCHITECTURE resistor_model;
FSYM
CNC(400 55)
CNC(295 55)
CNC(295 40)
CNC(400 55)
CNC(210 5)
LIG(295,70,310,70)
LIG(195,-25,215,-25)
LIG(295,30,295,40)
LIG(335,5,335,10)
LIG(295,5,295,10)
LIG(295,40,295,55)
LIG(335,35,335,40)
LIG(335,5,350,5)
LIG(350,40,350,30)
LIG(350,5,350,10)
LIG(335,40,350,40)
LIG(210,5,250,5)
LIG(400,40,400,55)
LIG(270,40,295,40)
LIG(250,40,250,70)
LIG(210,75,210,90)
LIG(210,5,210,15)
LIG(400,20,430,20)
LIG(425,40,425,55)
LIG(450,-10,450,20)
LIG(270,5,295,5)
LIG(295,55,400,55)
LIG(100,-30,145,-30)
LIG(435,-30,450,-30)
LIG(100,-5,120,-5)
LIG(120,-5,120,-25)
LIG(120,-25,145,-25)
LIG(295,55,295,70)
LIG(500,20,500,25)
LIG(485,20,500,20)
LIG(450,20,465,20)
LIG(400,55,425,55)
LIG(210,5,180,5)
LIG(180,5,180,10)
LIG(180,35,180,90)
LIG(195,-30,395,-30)
TEXT 312 79  #Criterion: vss-die over voltage
TEXT 232 119  #.AC DEC 10 1MEG 10G
FFIG D:\Documents and Settings\sicard\Mes documents\ic-em soft\Ic-em Export\icim_rfi_ic2.sch
