-- VHDL-AMS model of a Clock
-- author: Etienne Sicard, INSA Toulouse  
-- e-mail: etienne.sicard@insa-toulouse.fr
     
LIBRARY IEEE;
   USE IEEE.ELECTRICAL_SYSTEMS.ALL;

ENTITY ClockGenerator IS
  GENERIC(
          VLOW : real := 0.0;      -- low value
          VHIGH : real := 2.0;     -- high value
          TRISE : real := 1e-9;    -- rise time
          TFALL : real := 1e-9;    -- fall time
          TD    : time := 0.0 ns;  -- initial delay
          PWIDTH: time := 1.0 ns); -- pulse width          
  PORT (clkp,clkm : electrical);
END ENTITY ClockGenerator;


--  FUNCTION real2time(tt:real) RETURN time IS
--  BEGIN
--     return integer(tt*1.0e15)*1 fs;
--  END function;


ARCHITECTURE ClockGenerator_Model OF ClockGenerator IS

 QUANTITY vclock ACROSS iclock THROUGH clkp TO clkm;
 SIGNAL spulse : REAL = VLOW; -- the internal signal

  
BEGIN
   PROCESS 
   BEGIN
      WAIT for TD; -- nothing before initial delay
      LOOP
        spulse <= VHIGH;
        WAIT FOR PWIDTH;
        spulse <=VLOW;
        WAIT FOR PWIDTH;
      END LOOP;   
   END PROCESS;
   vclock == spulse'ramp(TRISE,TFALL);
END ARCHITECTURE ClockGenerator_Model;
