function fofz(q)
% F-of-z   plots of complex function F(z)=1/z
%          Experimental.

% RXon, 011209

if ~nargin
	q=0;
end
M=3;
x=(-M:0.1:M);
nx=length(x);
% a=nx^2;
% b=x((nx/2)+(-2:2));
y=j*x;
ny=length(y);

[X,Y]=meshgrid(x,y);
F=1 ./(X+Y);
for h=1:nx
	for k=1:ny
		if abs( F(h,k) ) > M
			F(h,k)=M*F(h,k)/abs(F(h,k));
		end
	end
end

figure(1)
% mesh( real(F), imag(Y), imag(F) )
if q
	surf( 1 ./real(F), imag(Y), imag(F) )
	xlabel('1/\Re\{\itF\rm(\itz\rm)\}')
else
	surf( real(F), imag(Y), imag(F) )
	xlabel('\Re\{\itF\rm(\itz\rm)\}')
end
ylabel('\itj\rm\Im\{\itz\rm\}')
zlabel('\itj\rm\Im\{\itF\rm(\itz\rm)\}')
axis( M * [ -1, 1, -1, 1, -1, 1 ] )
% axis equal square;
axis('square');
grid;
view(56,10);
