function srshpk(X)
% SRSHPK ... SeRies-SHunt PeaKing pole plots.

% RXon, 011101

if ~nargin
	X=1;
end

if X==1
	disp('1) MFA by RXon :')
	 n = 2/3
	m1 = 1/8
	m2 = 9/16
	c1 = [1, 1/m1, (m2*n+m1)/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n))]
	z1 = -1/m1
	p1 = roots(c1)

	disp('2) MFA by Braude :')
	 n = 0.596
	m1 = 0.143
	m2 = 0.583
	c2 = [1, 1/m1, (m2*n+m1)/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n))]
	z2 = -1/m1
	p2 = roots(c2)

	disp('3) MFA by Shea :')
	 n = 0.580
	m1 = 0.147
	m2 = 0.604
	c3 = [1, 1/m1, (m2*n+m1)/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n))]
	z3 = -1/m1
	p3 = roots(c3)

	plot( real(p1), imag(p1), '*b',...
         real(p2), imag(p2), 'xg',...
         real(p3), imag(p3), '+r',...
                0,        0, '.k' )
	axis equal square ;
	axis(3*[-1,1,-1,1]);	
	title( 'MFA-poles' )

elseif X==2

	disp('1) MFED by RXon :')
	 n = 0.7101
	m1 = 0.1000
	m2 = 0.4627
	c1 = [1, 1/m1, (m2*n+m1)/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n))]
	z1 = -1/m1
	p1 = roots(c1)

	disp('2) MFED by Braude :')
	 n = 0.656
	m1 = 0.122
	m2 = 0.511
	c2 = [1, 1/m1, (m2*n+m1)/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n))]
	z2 = -1/m1
	p2 = roots(c2)

	disp('3) MFED by Shea :')
	 n = 0.667
	m1 = 0.133
	m2 = 0.467
	c3 = [1, 1/m1, (m2*n+m1)/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n)), 1/(m1*m2*n*(1-n))]
	z3 = -1/m1
	p3 = roots(c3)

	plot( real(p1), imag(p1), '*b',...
         real(p2), imag(p2), 'xg',...
         real(p3), imag(p3), '+r',...
                0,        0, '.k' )
	axis equal square ;
	axis(4*[-1,1,-1,1]);	
	title( 'MFED-poles' )

end
