	% MFED (Shea) shunt-series (4-pole, 1-zero)
	t=t/2;
	% pole components
	s1 =-2.1250;
	w1 = 1.0971;
	s2 =-1.6231;
	w2 = 3.1625;
	
	% zero
	za=-7.4963
	% poles
	p=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2]
	
	% MFED (Braude) shunt-series (4-pole, 1-zero)
	t=t/2;
	% pole components
	s1 =-2.6032;
	w1 = 0.9618;
	s2 =-1.4951;
	w2 = 2.6446;
	
	% zero
	zb=-8.1967
	% poles
	q=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2]
	
	% Bessel poles
	[zc,b]=bestap(4,'t')
	zc=-10;
	
figure(1)
plot( real(p), imag(p), 'g*',...
      real(q), imag(q), 'bx',...
      real(b), imag(b), 'r+',...
      [-4,+4], [ 0, 0], '-k',...
      [ 0, 0], [-4,+4], '-k' )
axis('square')
% text( 0.1, 2.0, 'poles :' )
% text( 0.1, 1.5, 'Shea (red *)' )
% text( 0.1, 1.0, 'Bessel (blue +)' )
% text( 0.1, 0.5, ['Bessel x ' num2str(round(kx*100)/100), ' (green x)'] )
	
text( 1.5, 1.5, 'zero' );
text( 0.1, 1.0, ['  Shea :  ', num2str( round( 100*za )/100 ) ] );
text( 0.1, 0.6, ['Braude :  ', num2str( round( 100*zb )/100 ) ] );
text( 0.1, 0.2, ['Bessel :  ', num2str( round( 100*zc )/100 ) ] );
