% function cascode1
% cascode1 ... ???????

% RXon, 020622

f=logspace(4,10,601);
jw=j*2*pi*f;

ft1=500e+6;
rb1=15;
Ie1=0.01;
re1=0.026/Ie1;
gm1=1/re1;
Cp1=1/(2*pi*ft1*re1);
Rp1=100*0.7/Ie1;
Zp1=1 ./(jw*Cp1+1/Rp1);
Re1=100;
Ce1=3.3e-12;
% Ce1 = Cp1*re1/Re1 ;
Ze1=1 ./(jw*Ce1+1/Re1);
Cu1=3e-12;

ft2=500e+6;
rb2=15;
Le2=rb2 ./(2*pi*ft2);
Ze2=1 ./(1/rb2+1 ./(jw*Le2+rb2/100));

A=1+Ze2.*jw*Cu1;
B=(gm1+(1+Ze1./Zp1+gm1*Ze1).*jw*Cu1);
B=B./((1+jw*Cu1*rb1).*(1+Ze1./Zp1+gm1*Ze1)+(rb1 ./Zp1));

G=-B./(A+B.*Ze1.*jw*Cu1*rb1);
H=1000*G;

semilogx(f,20*log10(abs(H)),f,180*angle(H)/pi)
