% trtemp - transistor temperature dependence analysis
% RXon, 200411106

kB = 1.38e-23 ; % [VAs/K] Boltzmann constant

qe = 1.6e-19 ; % [C] electron charge

Tc = ( -40 : 5 : 160 ) ; % temperature in deg.C

T = 273 + Tc ; % [K] absolute temperature

VT = kB * T / qe ; % thermal voltage

Iso = 2e-14 ; % [A] saturation current in Si

Ico = 1e-3 ; % [A] collector current, constant bias

% nominal Vbe [V] at 20 deg.C :
Vbe20 = ( kB * (273 + 20 ) / qe ) * log( 1 + Ico / Iso ) ;

% approximate Vbe temperature coefficient [V/K] (negative!):
dVbe = -0.0025 ;

% simple Vbe model using the approx.temp.co.:
Vbe1 = Vbe20 * ( 1 + dVbe * ( T - 293 ) ) ;

% Vbe model using thermal voltage (assuming Ieo=Ico) :
Vbe2 = ( kB * T / qe ) * log( 1 + Ico / Iso ) ;

% forward beta (50x) and its temperature dependence (+0.7%/K)
betaF = 50 * ( 1 + 0.007 * ( T - 293 ) ) ;

% forward alpha
alphaF = betaF ./ ( 1 + betaF ) ;

% Vbe model using actual Ie = Ico / alphaF
% ==> almost no difference between Vbe3 and Vbe2 !
Vbe3 = ( kB * T / qe ) .* log( 1 + Ico ./ ( alphaF * Iso ) ) ;

% saturation current doubles approx. every 8 deg.C
% IsT = Iso * ( 1 + 2 .^( ( T - 293 ) / 8 ) ) ;
IsT = Iso * ( 2 .^( ( T - 293 ) / 8 ) ) ;

% saturation current model from SPICE
IsS = Iso * ( ( T / 293 ).^3 ) .* ( exp( ( -1.0 * qe / kB ) * ( ( 1 ./T ) - ( 1 / 293 ) ) ) ) ;


% Vbe model using saturation current temp.dep.
Vbe4 = ( kB * T / qe ) .* log( 1 + Ico ./ IsT ) ;

% Vbe model using both IsS and VT

Vbe5 = ( kB * T / qe ) .* log( 1 + Ico ./ IsS ) ;

plot( [Tc(1),20], [Vbe20,Vbe20], '--k',...
      Tc, Vbe1, '-b',...
      Tc, Vbe2, '-g',...
      Tc, Vbe3+0.005, '-r',...
      Tc, Vbe4, '-m',...
      Tc, Vbe5-0.005, '-k' )
xlabel( 'T [K-273]' ) ;
ylabel( 'Vbe [V] @ Ie=1mA' ) ;
text( -30, 0.64, 'Vbe20' ) ;
text( 50, 0.43, 'Vbe1=Vbe20*(1-0.0025*(T-293))' ) ;
text( 40, 0.85, 'Vbe2,3=(kb*T/qe)*ln(1+Ie/Is)' ) ;
text( 60, 0.62, 'Vbe4,5=(kb*T/qe)*ln(1+Ie/Is(T))' ) ;

