%ANOPT  draws optimisation curves according to the formula :
%
%       Tr/Ti = sqrt(N)*Atot^(1/N)
%
%       where   Tr   = system rise time
%               Ti   = individual stage rise time
%               N    = number of stages
%               Atot = total system gain

%       Erik Margan
%       Last corr.: 20022002

N=(5:1:100)/5;
n=max(size(N));
A=[2 5 10 20 50 100 200 500 1000];
a=max(size(A));
v=[1 20 1 10];
% axis(v);
for i=a:-1:1
	for j=1:n
		Tq(:,j)=A(i)^(1/N(j))*sqrt(N(j));
	end
	m=min(Tq);
	if i == a
		m1=0.05*m;
	end
	k=1;
	while (Tq(k)-m)>0
		k=k+1;
	end
	M(:,i)=m;
	X(:,i)=k;
	plot(N,Tq)
	text(N(k), m-m1, [' A=', num2str(A(i))]);
	hold on
end
plot(N(X),M,'-g',N(X),M,'or')
axis(v);
xlabel('Number of Amplifier Stages')
ylabel('System Rise-Time / Individual Stage Rise-Time')
title('System Rise-Time Optimization')
