function f461
% F461 ... WBAmps, Part 4, Sec. 6, Fig. 1
%      Frequency-response comparison of stagered
%      Bessel pole systems with repeating second-
%      -order pole systems.

%	Rxon, 030605

w=logspace(-1,1,301);
[z,p2]=bestap(2,'n');
[z,p4]=bestap(4,'n');
[z,p6]=bestap(6,'n');
[z,p8]=bestap(8,'n');
[z,p10]=bestap(10,'n');

F2=freqw(z,p2,w);
F4=freqw(z,p4,w);
F6=freqw(z,p6,w);
F8=freqw(z,p8,w);
F10=freqw(z,p10,w);

F24=F2.*F2;
F26=F24.*F2;
F28=F26.*F2;
F210=F28.*F2;

loglog( w, abs(F2), '-k',...
        w, abs(F24), '-r',...
        w, abs(F26), '-r',...
        w, abs(F28), '-r',...
        w, abs(F210), '-r',...
        w, abs(F4), '-b',...
        w, abs(F6), '-b',...
        w, abs(F8), '-b',...
        w, abs(F10), '-b')
axis([0.1,10,0.001,2]);

