% staggered vs. repeated pole pairs
% fig.4.x.xx

% RXon, 20020309

[z,p2]=bestap(2,'n');
[z,p4]=bestap(4,'n');
[z,p6]=bestap(6,'n');
[z,p8]=bestap(8,'n');
[z,p10]=bestap(10,'n');

w=logspace(-1,1,201);

t=0:0.05:10;

F2=freqw(p2,w);
F4=freqw(p4,w);
F6=freqw(p6,w);
F8=freqw(p8,w);
F10=freqw(p10,w);

G4=F2.*F2;
G6=G4.*F2;
G8=G6.*F2;
G10=G8.*F2;

figure(1);
loglog( w, abs(F2), '-k',...
        w, abs(F4), '-b',...
        w, abs(F6), '-b',...
        w, abs(F8), '-b',...
        w, abs(F10), '-b',...
        w, abs(G4), '-r',...
        w, abs(G6), '-r',...
        w, abs(G8), '-r',...
        w, abs(G10), '-r' );
axis([ 0.1, 10, 0.1, 2 ]);
grid;
xlabel( 'w/w0' )
ylabel( '|Fn(w)|, |G2k(w)|' )

h2=atdr(z,p2,t,'n');

f2=atdr(z,p2,t,'s');
f4=atdr(z,p4,t,'s');
f6=atdr(z,p6,t,'s');
f8=atdr(z,p8,t,'s');
f10=atdr(z,p10,t,'s');

g4=conv(f2,h2);
g4=g4(1:length(t));
g6=conv(g4,h2);
g6=g6(1:length(t));
g8=conv(g6,h2);
g8=g8(1:length(t));
g10=conv(g8,h2);
g10=g10(1:length(t));

figure(2);
plot( t, f2, '-k',...
      t, f4, '-b',...
      t, f6, '-b',...
      t, f8, '-b',...
      t, f10, '-b',...
      t, g4, '-r',...
      t, g6, '-r',...
      t, g8, '-r',...
      t, g10, '-r' );
xlabel( 't/T' );
ylabel( 'fn(t), g2k(t)' );
axis([0,10,0,1.2]);
grid;
