
function cfb
%CFB	Current-FeedBack Amplifier equations test.
%	Trans-Impedance Equation :
%					Vo = Ie * Zt
%	Feedback Error Current :
%					Ie = Vi/Rp + (Vi-Vo)/Rs =
%					   = Vi*(Rs+Rp)/(Rs*Rp) - Vo/Rs
%	Trans-Impedance Model :
%					Zt = 1/(1/Rt + j*w*Ct)
%	Closed-Loop Gain :
%				     Vo/Vi = (1+Rs/Rp)/(1+Rs/Zt) =
%			= (1+Rs/Rp)/((1+Rs/Rt)*(1+j*w*Ct*Rs*Rt/(Rs+Rt)))
%	Open-Loop Gain :
%				     Vo/Vi = Rt/(Rp*(1+j*w*Ct*Rt))
%	Non-Ideal Closed-Loop Gain :
%	    Vo/Vi = 1 ./((Rr+Rs*Rp/(Rs+Rp))*(1/Rt+w*Ct+1/(Rs+Rp*Rr/(Rp+Rr))))
%	Ie in time domain :
%	   Ie = Vi*(1/Rs+1/Rp)*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))))


%	E.M., 920702

Rs=3000;		% []
Rp=300;			% []
Rt=30000;		% []
Ct=600*10^(-12);	% [F]
Rr=15;			% []

f=logspace(3,6,301);
w=j*2*pi*f;
nt=161;
t=(0:1:nt-1)*10^(-7);
z=round(nt/8);
Vi1=ones(t);
Vi2=1-exp(-t/(Ct*Rs));
Vi3=1-exp(-t/(2*Ct*Rs));

% ----- 1 -----
Hc=(1+Rs/Rp) ./((1+Rs/Rt)*(1+w*Ct*Rs*Rt/(Rs+Rt)));
Ho=Rt ./(Rp*(1+w*Ct*Rt));
Hn=1 ./((Rr+Rs*Rp/(Rs+Rp))*(1/Rt+w*Ct+1/(Rs+Rp*Rr/(Rp+Rr))));
Hx=1 ./(1+w*Rs*Ct);

loglog(f,abs(Ho),f,abs(Hc),f,abs(Hn),f,abs(Hc.*Hx))
pause

% ------ 2 ------
loglog(f,abs(Ho))
hold on
for k=1:10
	Hc=(1+k*Rs/Rp) ./((1+k*Rs/Rt)*(1+w*Ct*k*Rs*Rt/(k*Rs+Rt)));
	loglog(f,abs(Hc),'-c5')
end
title('Rs to 10*Rs')
pause
hold off

% ---- 3 -------
loglog(f,abs(Ho))
hold on
for k=logspace(-1,1,21)
  Hn=1 ./((Rr+Rs*(Rp/k)/(Rs+(Rp/k)))*(1/Rt+w*Ct+1/(Rs+(Rp/k)*Rr/((Rp/k)+Rr))));
	loglog(f,abs(Hn),'-c5')
end
title('Rp to Rp/10')
pause
hold off

% ----- 4  -----
loglog(f,abs(Ho)/abs(Ho(1)))
hold on
for k=logspace(-1,1,21)
  Hn=1 ./((Rr+Rs*(Rp/k)/(Rs+(Rp/k)))*(1/Rt+w*Ct+1/(Rs+(Rp/k)*Rr/((Rp/k)+Rr))));
	Hn=abs(Hn)/abs(Hn(1));
	loglog(f,Hn,['-c' num2str(3+k)])
%	hold on
end
title('Rp to Rp/10, normalized')
pause
hold off

% ----- 5 ------
Ie1=(1/Rs+1/Rp)*Vi1.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie1=1000*([zeros(1:z+1) Ie1(1:nt-z-1)]);	%[mA]
Ie2=(1/Rs+1/Rp)*Vi2.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie2=1000*([zeros(1:z) Ie2(1:nt-z)]);		%[mA]
Ie3=(1/Rs+1/Rp)*Vi3.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie3=1000*([zeros(1:z) Ie3(1:nt-z)]);		%[mA]
t=1000000*t;					%[s]
plot(t,Ie1,'-r',t,Ie2,'-g',t,Ie3,'-b',0,-1)
title('Feedback Error Current Under Transient Condition')
xlabel('Time [us]')
ylabel('Current [mA]')
