function rlcz(N)
%RLCZ   R-L-C-Z network test for CFB amp.
%       Call :
%               rlcz(N)

%       E.M.

if nargin == 0
	N=1;
end

f=logspace(0,6,700);
jw=2*pi*j*f;
fx=logspace(0,6,7);
jwx=2*pi*j*fx;

%       Lo=16*10^(-6);          %[H]
%       Co=0.56*10^(-6);        %[F]
%       Ro=4.7;                 %[]
%       Rz=8;                   %[]

Lo=6.4*10^(-6);         %[H]
Co=0.1*10^(-6);         %[F]
Ro=8;                   %[]
Rz=8;                   %[]

Lz0=3.3*10^(-6);        %[H]
Lz1=10*10^(-2);         %[H]
Cz1=10^(-4);            %[F]
Rz0=6.8;                %[]
Rz1=17;                 %[]

if N == 1
	H=1 ./(1+(Ro/Rz)*(1+Rz*Co*jw)./(1+Ro ./(Lo*jw)));
	loglog(f,abs(H),'-c5')
	title('abs(H)')
	grid
	pause
	Z=Ro*Lo*jw./(Ro+Lo*jw) + Rz ./(1+Rz*Co*jw);
	Zx=Ro*Lo*jwx./(Ro+Lo*jwx) + Rz ./(1+Rz*Co*jwx);
	plot(0,0,10,0,real(Z),imag(Z),'-c5',real(Zx),imag(Zx),'oc12')
	title('Z Bode plot')
	pause
	plot(real(Z),imag(Z),'oc5')
	title('Z Bode plot')
	pause
	loglog(f,abs(Z))
	%,f,real(Z),f,abs(imag(Z)))
elseif N == 2
	Zz = jw*Lz0 + 1 ./(1/Rz1 +1 ./(Lz1*jw) + jw*Cz1) + Rz0;
	semilogx(f,abs(Zz),100,0)
	pause
	H=1 ./(1+(Ro ./Zz).*(1+Co*jw.*Zz)./(1+Ro ./(Lo*jw)));
	loglog(f,abs(H),'-c5')
	title('abs(H)')
	grid
	pause
	Z=Ro*Lo*jw./(Ro+Lo*jw) + Zz./(1+Co*jw.*Zz);
	Zzx = jwx*Lz0 + 1 ./(1/Rz1 +1 ./(Lz1*jwx) + jwx*Cz1) + Rz0;
	Zx=Ro*Lo*jwx./(Ro+Lo*jwx) + Zzx./(1+Co*jwx.*Zzx);
	plot(0,0,10,0,real(Z),imag(Z),'-c5',real(Zx),imag(Zx),'oc12')
	title('Z Bode plot')
	for k = 1:max(size(fx))
		text(real(Zx(k)),imag(Zx(k)),num2str(log10(fx(k))))
	end
	pause
	plot(real(Z),imag(Z),'oc5')
	title('Z Bode plot')
	pause
	loglog(f,abs(Z))
end
pause

disp(' ')
disp('VinRĿ')
disp('       L Vout')
disp('                   ')
disp('               C    Z')
disp('                   ')
disp('                   ')
disp(' ')
disp('    R []     L [H]    C [F]    Z []')
disp('-------------------------------------------')
disp([Ro Lo*1e6 Co*1e6 Rz])
