function a7bwmax
% A7BWMAX		Amplifier, 7-pole, 2-stage ; maximize bandwidth.
%				Experimental. Normalized bandwidth as a function
%				of Rb ( 0.7 ... 1.3 ). 

% RXon, 20030314

[z,p] = bestap(7,'t');
[K,ix] = sort( abs(p) );
p = p(ix) ;

% q = [ p(1) ; p(2) ; p(3) ; p(6) ; p(7) ; p(4) ; p(5) ] ;
% p = q ; 

Da = p(1) ;
Db = real( p(3) ) / ( cos( angle( p(3) ) ) )^2 ;
Dc = real( p(5) ) / ( cos( angle( p(5) ) ) )^2 ;
Dd = real( p(7) ) / ( cos( angle( p(7) ) ) )^2 ;

f = logspace( 6, 9, 601 ) ;
t = 1e-9 * ( 0 : 0.05 : 20 ) ;

A = 10 ;
Cb = 11e-12 ;
Ca =  4e-12 ;
gm0 = 0.01 ;

m = ( 0.7 : 0.1 : 1.3 ) ;

for k = 1 : length(m)
	Rb = sqrt( A ) / ( m(k) * gm0 ) ;
	
	Cc = Cb * ( Db / Dc ) / 2 ;
	Cd = 4 * Ca * ( Da / Dd ) ;
	
	Ra = Rb * ( Db / Da ) * ( Cb / Ca ) / 4 ;
	
	Lb = Rb^2 * Cb ;
	Ld = Ra^2 * Cd ;
	Lc = Rb^2 * Cc / ( 4 * ( cos( angle( p(3) ) ) )^2 ) ;
	
	kb = ( 3 - ( tan( angle( p(3) ) ) )^2 ) / ( 5 + ( tan( angle( p(3) ) ) )^2 ) ;
	kd = ( 3 - ( tan( angle( p(7) ) ) )^2 ) / ( 5 + ( tan( angle( p(7) ) ) )^2 ) ;
	
	Cbb = Cb * ( 1 + ( tan( angle( p(3) ) ) )^2 ) / 16 ;
	Cbd = Cd * ( 1 + ( tan( angle( p(7) ) ) )^2 ) / 16 ;
	
	disp( [ num2str(k), ')' ] ) ;
	disp( '    Rb[k]     Ra[k]     Cc[pF]    Cd[pF]    Cbb[pF]   Cbd[pF]   ' ) ;
	disp( '---------------------------------------------------------------' ) ;
	disp( [ 1e-3*[ Rb, Ra], 1e+12*[ Cc, Cd, Cbb, Cbd ] ] ) ;
	disp( ' ' ) ;
	disp( '    Lb[uH]    Lc[uH]    Ld[uH]    kb        kd     ' ) ;
	disp( '---------------------------------------------------' ) ;
	disp( [ 1e+6*[ Lb, Lc, Ld ], kb, kd ] ) ;
	disp( ' ' ) ;  
	
	pa = -1 / ( Ra * Ca ) ;
	
	re = cos( angle( p(3) ) ) ;
	im = sin( angle( p(3) ) ) ;
	pb = [ -re + j*im ; -re - j*im ] ;
	pb = pb * 4 * cos( angle( p(3) ) ) / ( Rb * Cb ) ;
	
	re = cos( angle( p(5) ) ) ;
	im = sin( angle( p(5) ) ) ;
	pc = [ -re + j*im ; -re - j*im ] ;
	pc = pc * 2 * cos( angle( p(5) ) ) / ( Rb * Cc ) ;
	
	re = cos( angle( p(7) ) ) ;
	im = sin( angle( p(7) ) ) ;
	pd = [ -re + j*im ; -re - j*im ] ;
	pd = pd * 4 * cos( angle( p(7) ) ) / ( Ra * Cd ) ;
	
	q = [ pa ; pb ; pc ; pd ] ;
	
	figure(1)
	plot( real(q), imag(q), '*b' )
	axis equal ;
	hold on ;
	
	F = freqw( z, q, 2*pi*f ) ;
	figure(2)
	loglog( f, abs( F ) )
	axis( [ 1e+6, 1e+9, 0.1, 1.0] ) ;
	hold on ;
	
	y = atdr( z, q, t ) ;
	figure(3)
	plot( t, y )
	hold on ;
	
	gm1 = sqrt( A ) / Ra ;
	gm2 = sqrt( A ) / Rb ;
end
