function [E,A]=ellipfit(p,d,s1,s2)
% ELLIPFIT ... ellipse fit to poles of a system.
%
%	Call :  [ E, A ] = ellipfit( p, d ) ;
%	where	p ..... system poles in the complex plane
%			d ..... ploting option, plots the poles and the elllipse if non-zero
%			E ..... a 101-by-2 matrix of [X(:), Y(:)] coordinates of the ellipse
%			A ..... a1-by-4 matrix of ellipse parameters :
%			excentricity, major axis, minor axis, intersection with the real axis

% RXon, 880311
% Last update : 000208
% A should return either the center of symmetry or both focus coordinates !!!!!
% This has not been done yet !

if nargin < 4
	s2='-r';
end
if nargin < 3
	s1='*b';
end
if nargin < 2
	d=0;
end

test = 0 ;
tx = 1 ;

np = max( size( p ) ) ;
p = sort( p ) ;

p1 = abs( p( 1 ) ) ;
p2 = abs( p( np ) ) ;

x1 = real( p( 1 ) ) ;
x2 = real( p ( np ) ) ;

y1 = imag( p( 1 ) ) ;
y2 = imag( p ( np ) ) ;

s=sum(abs(imag(p)))-sum(abs(real(p)));
if s > 0
        % Chebyshew system
        exc = sqrt( 1 + ( x1^2 - x2^2 ) / ( y1^2 - y2^2 ) ) ;
        a = sqrt( y2^2 - x2^2 / ( exc^2 - 1 ) ) ;
        c = abs( a * exc ) ;
        b = a * sqrt( 1 - exc^2 ) ;
        y0 = a ; 
        x0 = -abs( b ) ;
elseif abs(s) < 1e-6
        %Butterworth system
        exc = 0 ;
        c = 0 ;
        a = p1 ;
        b = a ;
        x0 = a ;
        y0 = a ;
else
        % Bessel system
        exc = ( p2 - p1 ) / ( x1 - x2 ) ;
        a = ( p2 + exc * x2 ) / ( 1 - exc^2 ) ;
        c = abs( a * exc ) ;
        b = a * sqrt( 1 - exc^2 ) ;
        y0 = b^2 / a ; 
        x0 = c - a ;
end

if test
        a
        b
        c
        exc
        pause
        p
        x0
        y0
        pause
end


xx = x0 * ( 0 : 1 / 100 : 1 ) ;

if s > 0
        % Chebyshew system
        yy = a * sqrt( 1 - xx.^2 / b^2 ) ;
elseif abs(s) < 1e-6
        %Butterworth system
        yy = sqrt( a^2 - xx.^2 ) ;
else
        % Bessel system
        yy = b * sqrt( 1 - ( xx - c ).^2 / a^2 ) ;
end

xx = [ xx, xx( max(size(xx))-1 : -1 : 1 ) ] ;
yy = [ yy, -yy( max(size(yy))-1 : -1 : 1 ) ] ;
E = [xx(:), yy(:) ] ;

if d

        plot( real(p), imag(p), s1, xx, yy, s2 )
        axis('square') ;
        ax = ceil( 2 * max( abs( [ imag( p(:) ) ; real( p(:) ) ] ) ) ) / 2 ;
        if tx
                axis([ -2*ax,0,-ax,ax]) ;
        end
	drawnow ;
        if test
                pause
        end

        if tx
                axis ;
        end
        axis('normal') ;
end
A = [ exc, a, b, x0 ] ;

if test
        disp( '     exc      a         b        x0' )
        disp([ exc, a, b, x0 ] )
        disp(' ')
        disp([ xx(1),xx(26),xx(51),xx(76),xx(101) ])
        disp([ yy(1),yy(26),yy(51),yy(76),yy(101) ])
end
