function fig61
% Fig. 6.1.X
% Complete 5th-order Butterworth system representation.

% RXon, 890112
% Last revision (Matlab-IV) : 000130
% Revision Matlab-V : 000819

% get Matlab version number :
if ~exist('version')
	matver='1.0';
else
	matver=version;
end
matver=str2num(matver(1));

[z,p]=buttap(5);	% a 5th order Butterworth system zeros and poles
[row,col]=size(p);


% -------------- Fig.6.1.1. ------------- ;
% ----- polar-coordinates pole loci ----- ;
figh=figure(1) ;
A=zeros(row,col);
B=atan(imag(p)./real(p));
C=-abs(p);
Q=[A,B];
Q=Q.';
Q=Q(:);
R=[A,C];
R=R.';
R=R(:);
polar( B, C, '*r')
hold on
polar( Q, R, '-r')
hold off
grid
if matver < 4
	xlabel(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
elseif matver == 4
	text(-0.9,-1.25,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
else
	text(-0.9,-1.25,['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Poles'])
	% xlabel(['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Poles'])
end
if matver < 4
	text( 1.2, 0.0, 'Real{s}' )
	text( -0.2, 1.25, 'Imag{s}' )
elseif matver == 4
	txh=text( 1.2, 0.0, 'Real{s}' );
	% set(txh,'FontAngle','Italic');
	txh=text( -0.2, 1.25, 'Imag{s}' );
	% set(txh,'FontAngle','Italic');
else
	text( 1.2, 0.0, '\Re\{{\its}\}','FontSize',16 )
	text( -0.1, 1.25, '\Im\{{\its}\}','FontSize',16 )
end


% -------------- Fig.6.1.2. ----------------- ;
% ----- cartesian-coordinates pole loci ----- ;
figh=figure(figh+1) ;
P=[p(:).'; zeros(size( p(:).' ) )];
P=P(:);
theta=(0:pi/180:2*pi);
if matver > 3
	fill( [ -2, 0, 0, -2 -2 ], [ -2, -2, 2, 2, -2 ], [ 0.82, 0.82, 0.82 ] ) ;
	hold on
	axis('manual')
end
plot([-1.99,1.99],[0,0],'-k',...
     [0,0],[-1.99,1.99],'-k',...
     sin(0:pi/180:2*pi),cos(0:pi/180:2*pi),'-b',...
     real(P),imag(P),'-r',...
     real(p),imag(p),'*r')
axis('square')
axis([-2,2,-2,2]);
for kx = 1 : length(p)
	if matver < 5
		text( real(p(kx))-0.3, imag(p(kx))+0.2*sign(0.1+imag(p(kx))), ['p', num2str(kx)] ) ;
	else
		text( real(p(kx))-0.3, imag(p(kx))+0.2*sign(0.1+imag(p(kx))), ['{\itp}_', num2str(kx)],'FontSize',16 ) ;
	end
end
if matver > 3
	axh=gca;
	set(axh,'XTickMode','Manual','XTickLabelMode','Manual');
	set(axh,'YTickMode','Manual','YTickLabelMode','Manual');
	set(axh,'XTick',[-2,-1.5,-1,-0.5,0,0.5,1,1.5,2]);
	set(axh,'YTick',[-2,-1.5,-1,-0.5,0,0.5,1,1.5,2]);
	if matver == 4
		set(axh,'XTickLabels',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
		set(axh,'YTickLabels',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
	else
		set(axh,'XTickLabel',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
		set(axh,'YTickLabel',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
	end
end
if matver < 4
	text(1.2,0.20,'Real{s}')
	text(0.1,1.75,'Imag{s}')
	title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
elseif matver == 4
	txh=text(1.2,0.20,'Real{s}');
	% set(txh,'FontAngle','Italic');
	txh=text(0.1,1.75,'Imag{s}');
	% set(txh,'FontAngle','Italic');
	text(-1.8,2.2,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
else
	text(1.2,0.20,'\Re\{{\its}\}','FontSize',16)
	text(0.1,1.75,'\Im\{{\its}\}','FontSize',16)
	title(['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Poles'])
end


% -------------- Fig.6.1.3. ---------------- ;
% ----- 3-D Magnitude over the s-plane ----- ;
figh=figure(figh+1) ;
% xyz( z, p, -2, 2, 12 ) ;
% xyz( Zeros, Poles, RealRange, ImagRange, HightRange, Resolution, MeshType, LabelFalg );
xyz( z, p, -2, 2, 12, 50, 1, 0 ) ;
axis([-2,0,-2,2,0,12]);
if matver < 4
	text( -1.2, 0.5, 12, 'up to infinity' )
elseif matver == 4
	txh=text( -1.2, 0.5, 12, 'x   ' );
	set( txh, 'FontName','BCSYMA','FontSize',16,'String',setstr( [197,32,95] ) );
else
	text( -1.4, 0.6, 12, '\uparrow\infty','FontSize',16 );
end
if matver > 3
	axh=gca;
	if matver > 4
		set(axh,'ZTick',[0,4,8,12],'ZTickLabel',[' 0';' 4';' 8';'12']);
	else
		set(axh,'ZTick',[0,4,8,12],'ZTickLabels',[' 0';' 4';' 8';'12']);
	end
end

if matver < 4
	xlabel( 'sigma=Real{s}' )
elseif matver == 4
	txh=text(-1,-3,-1,'x');
	% display greek 'sigma' from the BCSYMB (WinEXP) font, instead of x :
	set(txh,'FontName','BCSYMB','FontSize',16,'String',setstr(53));
	text(-1,-3,-1,'   = Real{s}')
else
	text(-1,-3,-1,'{\it\sigma} = \Re\{{\its}\}','FontSize',16)
end   

if matver < 4
	ylabel( 'j*omega = j*Imag{s}' )
elseif matver == 4
	txh=text(0,0,-2,'  x');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	% keep the spaces for correct alignment !
	set(txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(61)]); % display 'omega'
	text(0,0,-2,'j    = j*Imag{s}')
else
	text(0,0,-2,'{\itj\omega} = {\itj}\Im\{{\its}\}','FontSize',16)
end

if matver < 5
	zlabel( 'M(s) = |F(s)|' )
else
	zlabel( '{\itM}({\its}) = |{\itF}({\its})|','FontSize',16)
end

if matver < 4
	title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude over s-Plane'] )
elseif matver == 4
	text(-1.8,-1.8,14, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude over s-Plane'] )
else
	title( ['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Magnitude over {\its}-Plane'] )
end   


% -------------- Fig.6.1.4. ------------------------------- ;
% ----- 3-D Helix, complex-frequency complex response ----- ;  
figh=figure(figh+1) ;
jw=(-3:0.01:3);			% 601 frequency points, pos. and neg., linear scale
G=freqw(z,p,jw(301:601));	% 301 points of complex frequency response
G=[real(G(301:-1:2))-j*imag(G(301:-1:2)), G];	% full +/-3 freq.range
xyp=[	-3.0,  3.0,  3.0, -3.0, -3.0 ;...
		-1.5, -1.5,  1.5,  1.5, -1.5 ;...
		 0.0,  0.0,  0.0,  0.0,  0.0 ];
xzp=[	-3.0,  3.0,  3.0, -3.0, -3.0 ;...
		 0.0,  0.0,  0.0,  0.0,  0.0 ;...
		-1.5, -1.5,  1.5,  1.5, -1.5 ];
yzp=[	 0.0,  0.0,  0.0,  0.0,  0.0 ;...
		-1.5,  1.5,  1.5, -1.5, -1.5 ;...
		-1.5, -1.5,  1.5,  1.5, -1.5 ];
box=[	 3.0,  3.0,  3.0, -3.0, -3.0, -3.0,  3.0 ;...
		-1.5, -1.5,  1.5,  1.5, -1.5, -1.5, -1.5 ;...
		-1.5,  1.5,  1.5,  1.5,  1.5,  1.5,  1.5 ];
bix=[	-3.0,  3.0,  3.0 ;...
		 1.5,  1.5, -1.5 ;...
		-1.5, -1.5, -1.5 ];
boy=[	-3.0, -3.0 ;...
		-1.5, -1.5 ;...
		-1.5,  1.5];
boz=[	 3.0,  3.0 ;...
		 1.5,  1.5 ;...
		-1.5,  1.5 ];

plot3(	[-3, 3], [0, 0], [0, 0], '-g',...
		[0, 0], [-1.5, 1.5], [0, 0], '-b',...
		[0, 0], [0, 0], [-1.5, 1.5], '-m',...
		xyp(1,:), xyp(2,:), xyp(3,:), ':k',...
		xzp(1,:), xzp(2,:), xzp(3,:), ':k',...
		yzp(1,:), yzp(2,:), yzp(3,:), ':k',...
		bix(1,:), bix(2,:), bix(3,:), '--k',...
		box(1,:), box(2,:), box(3,:), '-k',...
		boy(1,:), boy(2,:), boy(3,:), '-k',...
		boz(1,:), boz(2,:), boz(3,:), '--k',...
		jw, imag(G), real(G), '-r',...
		0, 0, 1, 'ok')
view(-40,20);
axis([-3,3,-1.5,1.5,-1.5,1.5]) ;

% vector( [ 1.25, 0.00, 0.00, 1.50, 0.00, 0.00 ], 'g', 0.5 );
% vector( [ 0.00, 1.25, 0.00, 0.00, 1.50, 0.00 ], 'b', 0.5 );
% vector( [ 0.00, 0.00, 1.25, 0.00, 0.00, 1.50 ], 'm', 0.5 );

% grid;
if matver > 3
	axh=gca ;
	if matver > 4
		set(axh,'XTick',[-3,-2,-1,0,1,2,3],'XTickLabel',['-3';'-2';'-1';' 0';' 1';' 2';' 3']);
		set(axh,'YTick',[-1.5,-1,-0.5,0,0.5,1,1.5],'YTickLabel',['-1.5';' -1 ';'-0.5';'  0 ';' 0.5';'  1 ';' 1.5']);
	else
		set(axh,'XTick',[-3,-2,-1,0,1,2,3],'XTickLabels',['-3';'-2';'-1';' 0';' 1';' 2';' 3']);
		set(axh,'YTick',[-1.5,-1,-0.5,0,0.5,1,1.5],'YTickLabels',['-1.5';' -1 ';'-0.5';'  0 ';' 0.5';'  1 ';' 1.5']);
	end
end

if matver < 4
	text( 3, -0.2, 0.2, 'j*omega')
elseif matver == 4
	txh=text( 3, -0.2, 0.2, '  x');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set(txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(61)]); % display 'omega'
	text( 3, -0.2, 0.2, 'j    ');
else
	text( 3, -0.2, 0.2, '{\itj\omega}','FontSize',16);
end

if matver < 4
	text( -2, 1.5, 0.5, 'Imag{F(jw)' )
	text(  0.3, 0.6, 1.50, 'Real{F(jw)}' )
elseif matver == 4
	txh=text( -2, 1.5, 0.5, 'Imag{F(jw)}' );
	set(txh,'FontAngle','Italic');
	txh=text( 0.3, 0.6, 1.50, 'Real{F(jw)}' );
	set(txh,'FontAngle','Italic');
else
	text( -2, 1.5, 0.5, '\Im\{{\itF}({\itj\omega})\}','FontSize',16 )
	text( 0.3, 0.6, 1.50, '\Re\{{\itF}({\itj\omega})\}','FontSize',16 )
end

if matver < 4
	title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Complex-Frequency Response'])
elseif matver == 4
	text(-3.0,2.0,1.8,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Complex-Frequency Response'])
else
	title(['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Complex-Frequency Response'])
end


% -------------- Fig.6.1.5. -------------------------------------------- ;
% ----- Bode-plot : single-side complex-frequency complex response ----- ;
% figh=figure(figh+1) ;
figh=5;
figure(figh);
w=logspace(-3,1,601);	% 601 frequency points, equally spaced in
							% 3-decade log scale from 0.01 to 10 ;
H=freqw(z,p,w);			% 601 points of complex frequency response ;
Q=(pi/2)+(0:0.05*pi/3:pi/3);
plot([-1,1], [0,0], '-k',...
     [0,0], [-1,1], '-k',...
     0.23*sin(Q), 0.23*cos(Q), '-b',...
     1, 0, 'ob',...
     -0.5, 0.5, 'ob',...
     0, 0, 'ob',...
     real(H), imag(H), '-r')
axis('square')
axis('manual')
hold on

% deleted from the "plot"2 command above :
%     [0,real(H(380))], [0,imag(H(380))], '-b',...
% replaced by the "vector()" command :
vector( [ 0, 0, real(H(380)), imag(H(380)) ], 'b', 1.0 ) ;
vector( [ 0.24, -0.22, 0.22, -0.24 ]/sqrt(2), 'b', 0.2 ) ;

lh = line( [ 0.45, 0.75 ], [ 0.25, 0.25 ] ) ;
set( lh, 'Color', 'k', 'LineStyle', '-', 'LineWidth', 0.5 ) ;
vector( [ 0.75, 0.25, 0.95, 0.05 ], 'k', 0.5 ) ;

lh = line( [ -0.55, -0.25 ], [ -0.25, -0.25 ] ) ;
set( lh, 'Color', 'k', 'LineStyle', '-', 'LineWidth', 0.5 ) ;
vector( [ -0.25, -0.25, -0.05, -0.05 ], 'k', 0.5 ) ;

lh = line( [ -0.25, -0.75 ], [ 0.75, 0.75 ] ) ;
set( lh, 'Color', 'k', 'LineStyle', '-', 'LineWidth', 0.5 ) ;
vector( [ -0.75, 0.75, -0.55, 0.55 ], 'k', 0.5 ) ;

% axis labels :
if matver < 4
	text(0.3, 0.07, 'Real{F(jw)}');
	text(0.05, 0.8, 'Imag{F(jw)}');
elseif matver == 4
	txh=text(0.3, 0.07, 'Real{F(jw)}');
	set(txh,'FontAngle','Italic');
	txh=text(0.05, 0.8, 'Imag{F(jw)}');
	set(txh,'FontAngle','Italic');
else
	text(0.3, 0.07, '\Re\{{\itF}({\itj\omega})\}','FontSize',16);
	text(0.05, 0.8, '\Im\{{\itF}({\itj\omega})\}','FontSize',16);
end

% angle label :
if matver < 4
	text( 0.2, -0.1, 'atan(Im(F)/Re(F))' );
elseif matver == 4
	txh=text( 0.05, -0.1, 'x  ' );
	% display greek 'varphi' from BCSYMB (WinEXP) font, istead of x :
	set( txh, 'FontName', 'BCSYMB', 'FontSize', 16, 'String', setstr(58) ) ;
	text( 0.05, -0.1, '   = atan(Im(F)/Re(F))' );
else
	% original text :
	% text( 0.25, -0.15, '{\it\phi}={\itatan}(\Im({\itF}({\itj\omega}))/\Re({\itF}({\itj\omega})))' );
	
	% fraction midline :
	lh=line( [0.45, 0.95], [-0.2, -0.2] ) ;
	set( lh, 'LineStyle','-','Color','k' ) ;

	% txh=text( 0.05, -0.2, 'x ' ) ;
	txh=text( 0.1, -0.07, 'x ' ) ;
	% display greek 'varphi' from BCSYMB (WinEXP) font,
	% istead of x , since Matlab-V does not recognize varphi :
	set( txh, 'FontName', 'BCSYMB', 'FontSize', 16, 'String', setstr(58) ) ;

	% txh=text( 0.44, -0.2, '{\it\phi} = {\itatan}' );
	txh=text( 0.44, -0.2, '= {\itatan}' );
	set( txh, 'HorizontalAlignment','Right','FontSize',16 ) ;
	% numerator
	text( 0.48, -0.12, '\Im\{{\itF}({\itj\omega})\}','FontSize',16 );
	% denominator
	text( 0.48, -0.28, '\Re\{{\itF}({\itj\omega})\}','FontSize',16 );
end

% Magnitude label :
if matver < 4
	text( 0.3, -0.5, 'M(w)=|F(jw)|' );
elseif matver == 4
	txh=text( 0.3, -0.5, 'M(w)=|F(jw)|' );
	set(txh,'FontAngle','Italic');
else
	text( 0.3, -0.5, '{\itM}({\it\omega}) = |{\itF}({\itj\omega})|','FontSize',16 );
end

if matver < 4
	% text( 1.03, 0.1, 'w=0' );
	text( 0.5, 0.25, 'w=0' );
elseif matver == 4
	txh=text( 0.5, 0.25, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
	text( 0.5, 0.25, '   = 0');
else
	text( 0.5, 0.25, '{\it\omega} = 0','FontSize',16,'VerticalAlignment','Bottom');
	% text( 1.03, 0.08, '{\it\omega} = 0','FontSize',16);
	% text( 1.06, 0, '\leftarrow','FontSize',16 )
end

if matver < 4
	% text( -0.75, 0.55, 'w=1' );
	text( -0.65, 0.75, 'w=1' );
elseif matver == 4
	txh=text( -0.65, 0.75, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
	text( -0.65, 0.75, '   = 1');
else
	% txh=text( -0.5, 0.6, '\downarrow' ) ;
	% set( txh, 'HorizontalAlignment','center','FontSize',16 ) ;
	% text( -0.47, 0.7, '{\it\omega} = 1','FontSize',16);
	text( -0.65, 0.75, '{\it\omega} = 1','FontSize',16,'VerticalAlignment','Bottom');
end

if matver < 4
	% text( -0.3, -0.15, 'w=inf' );
	text( -0.5, -0.25, 'w=inf' );
elseif matver == 4
	% txh=text( -0.3, -0.06, 'x ');
	txh=text( -0.5, -0.25, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
	% txh=text( -0.3, 0.06, '     x ');
	txh=text( -0.5, -0.25, '     x ');
	% display 'infinity' from BCSYMA (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMA','FontSize',16,'String',['     ', setstr(95)] );
	% text( -0.3, 0.05, '   =');
	text( -0.5, -0.25, '   =');
else
	text( -0.6, -0.25, '{\it\omega} = \infty','FontSize',16,'VerticalAlignment','Bottom');
	% text( -0.3, 0.1, '{\it\omega} = \infty','FontSize',16);
	% text( -0.17, -0.02, '\rightarrow','FontSize',16 ) ;
end

if matver < 4
	title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot']);
elseif matver == 4
	text(-1,1.05,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot']);
else
	title(['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Bode-Plot']);
end


% -------------- Fig.6.1.6. -------- ;
% ----- Lin-lin Magnitude plot ----- ;
figh=figure(figh+1) ;
M=abs(H);		% magnitude
ix=max(find(w<=3));	% limit the frequecy scale to 3.
% display M in lin-lin plot :
plot([w(1),w(ix)],[0.707,0.707],'-k',...
     [1,1],[0,1.19],'-k',...
     w(1:ix),M(1:ix),'-r',...
	  [1],[0.707],'ob')
axis([0, 3, 0, 1.2]);
xlabel( 'Frequency' )
ylabel( 'Magnitude' )
if matver < 4
	text( 1.1, 0.74, '0.707' );
else
	txh=text( 1.1, 0.74, '0.707' );
	set( txh, 'FontSize',16 ) ;
end

if matver < 4
	title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] );
elseif matver == 4
	text(0.2,1.25, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] );
else
	title( ['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Magnitude'] );
end


% -------------- Fig.6.1.7. --------------- ;
% ----- Nyquist plot : log10(f)-dB(M) ----- ; 
figh=figure(figh+1) ;
w=w(301:601);		% limit the frequency to -/+1decade
H=H(301:601);
M=abs(H);		% magnitude
% display M in dB vs. log-scale w
semilogx( w, 20*log10(M),'-r', [0.7, 1.4], [-3, -3], '-b', [1, 1], [0, -10], '-b' )
axis( [ 0.1, 10, -100, 0 ] ) ;
if matver > 3
	axh=gca;
	if matver > 4
		set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
	else
		set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);
	end
end

if matver == 4
   text( 1.2, -95, 'Frequency' )
else   
   xlabel( 'Frequency' )
end

ylabel( 'Magnitude [dB]' )

text( 0.6, -6, '-3dB' )
text( 3, -40, 'Slope :' )
text( 3.5, -50, '-100dB/10f' )

if matver < 4
	title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )
elseif matver == 4
	text(0.15,5, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )
else
	title( ['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Magnitude'] )
end


% -------------- Fig.6.1.8. ------------ ;
% ----- Nyquist plot : phase angle ----- ;
figh=figure(figh+1) ;
phi=angle(H);		% phase response, modulo +/-pi
semilogx([min(w),max(w)],[pi,pi],'--b',...
         [min(w),max(w)],[-pi,-pi],'--b',...
         w,phi,'-r')
if matver > 3
	axh=gca;
	if matver > 4
		set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
	else
		set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);
	end
end

if matver == 4
	text( 1.2, -3.6, 'Frequency' )
else
	xlabel( 'Frequency' )
end

if matver < 4
	text( max(w)/3, pi+0.25, '+pi' );
	text( max(w)/3, -pi+0.25, '-pi' );
elseif matver == 4
	txh=text( max(w)/3, pi+0.25, '+pi' );
	% display greek 'pi' from BCSYMB (WinEXP) font, instead of +pi :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(49)] );
	text( max(w)/3, pi+0.25, '+  ' );
	txh=text( max(w)/3, -pi+0.25, '-pi' );
	% display greek 'pi' from BCSYMB (WinEXP) font, instead of -pi :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(49)] );
	text( max(w)/3, -pi+0.25, '-  ' );
else
	text( max(w)/3, pi+0.25, '+\pi','FontSize',16 );
	text( max(w)/3, -pi+0.25, '-\pi','FontSize',16 );
end

ylabel( 'Phase angle [rad]' )

if matver < 4
	title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Phase'] )
elseif matver == 4
	text(0.15,4.4, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Phase'] )
else
	title( ['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Phase'] )
end


% -------------- Fig.6.1.9. ------------------- ;
% ----- phase angle unwrapped, in degrees ----- ;
figh=figure(figh+1) ;
% unwrap the phase :
alpha=ephd(phi);
% display alpha in linear degrees
semilogx(w,180*alpha/pi,'-r')
if matver > 3
	axh=gca;
	set(axh, 'YTick', [ -450, -360, -270, -180, -90, 0 ] ) ;
	if matver > 4
		set(axh, 'YTickLabel', [ '-450'; '-360'; '-270'; '-180'; ' -90'; '   0' ] ) ;
		set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
		xlabel( 'Frequency' )
	else
		set(axh, 'YTickLabels', [ '-450'; '-360'; '-270'; '-180'; ' -90'; '   0' ] ) ;
		set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);
		text( 1.2, -475, 'Frequency' )
	end
else
	xlabel( 'Frequency' )
end

if matver < 5
	ylabel( 'Phase Angle [degrees]' )
else
	ylabel( 'Phase Angle [\circ]' )
end

if matver < 4
	title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Unwrapped Phase'] )
elseif matver == 4
	text(0.15,20, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Unwrapped Phase'] )
else
	title( ['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Unwrapped Phase'] )
end


% -------------- Fig.6.1.10. ------------ ;
% ----- group (envelope) time-delay ----- ;
figh=figure(figh+1) ;
tau=diff(alpha)./diff(w);		% time-delay
w=sqrt(w(2:1:301).*w(1:1:300));		% new w
semilogx(w,tau,'-r')			% plot
if matver > 3
	axh=gca;
	if matver > 4
		set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
	else
		set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
	end
end

if matver == 4
   text( 1.2, -5.7, 'Frequency' )
else   
   xlabel( 'Frequency' )
end

ylabel( 'Time-Delay [s]' )

if matver < 4
	title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Envelope-Delay'] )
elseif matver == 4
	text(0.15,0.25, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Envelope-Delay'] )
else
	title( ['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Envelope-Delay'] )
end   


% -------------- Fig.6.1.11. --------------------------------- ;
% ----- time-domain response : impulse and step function ----- ;
figh=figure(figh+1) ;
w=(0:1:255)/4;		% linear frequency vector
H=freqw(z,p,w);		% complex frequency response in new w ;
[I,t]=tresp(H,w,'i');	% impulse response
[S,t]=tresp(H,w,'s');	% step response
nt=min( find( t > 20 ) ) - 1 ;	% limit time to 25*Tnorm
t=t(1:nt);
I=I(1:nt);
S=S(1:nt);
plot( t, I, '-r', t, S, '-b' )
text(8,0.15, 'Impulse-Response' )
text(8,0.85, 'Step-Response' )
xlabel( 'Time [s]' )
ylabel( 'Amplitude' )
if matver < 4
	title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth in Time Domain'] )
elseif matver == 4
	text(0,1.3, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth in Time Domain'] )
else
	title( ['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth in Time Domain'] )
end
