function fig654w
% FIG654w		Window example for 1st-order system.
%				Window is Hanning.

% RXon, 000215

z=[];
p=-1;
w=(0:1:255)/8;

F=freqw(z,p,w);

W=( cos( (pi/2)*(0:1:255)/255 ).^2 ) ;

plot(w,abs(F),'-r',w,W,'-g',w,abs(W.*F),'-b')
xlabel( 'Frequency')
text( 2, 1.05, 'Fig. 6.4. : Windowing of 1st-order system' )
text( 19, 0.4, 'W' ) ;
text( 15, 0.1, 'abs(F(jw))' ) ;
text( 3, 0.05, 'abs(W*F(jw))' ) ;