function fig655_1(m,N,X,s)
% FIG655_1
%	Impulse response calculated from a normal and windowed
%	1st-order frequency response.

% RXon, 000215


if nargin < 4
	s = 'i' ; 	% impulse-response selected
end
if s ~= 's' & s ~= 'S'
	s = 'i' ;
end
if nargin < 3
	X=1 ;		% system order
end
if nargin < 2
	N=256 ;		% w, F, t and I vector lagth
end
if nargin < 1
	m=8 ;		% frequency renormalization 
end

% ----- system poles -----
[z,p]=buttap(X);

% ----- frequency vector -----
w=(0:1:N-1)/m;

% ----- time-vector -----
q = 2 * pi * m / N ;
t = q * (0:1:N-1) ;
x=max(find(t<=5));

% ----- window function construction -----
% M=7*N/8;
% M=N-2;
M=N-1;
W=cos( (pi/2)*(0:1:M)/(M) ).^2 ;	
% W=[W, zeros(1,N-M-1)];
% W=(cos((pi/2)*(0:1:6*N/8)/(6*N/8))).^2;
% W=[ones(1,N/8-1), W, zeros(1,N/8)];

% ----- frequency response and system gain -----
F=freqw(z,p,w);
% plot(w,abs(F),'-r',w,abs(F.*W),'-b'),pause
G=abs(F(1));

% ----- impulse response from F -----
In=2*real(fft(conj(F)))-1;
In=In/(N*(2*G-1));

% ----- impulse response from F.*W -----
Iw=2*real(fft(conj(F.*W)))-1;
Iw=Iw/(N*(2*G-1));

% ----- reference system time-domain response -----
if X == 1
	Id = exp( -t ) ;
else
	Id = tdr( z, p, t, 'i' );
end
Id=2*pi*m*Id/N;


% ----- first-point amplitude correction -----
% In = [ 0, In(2:N) ] ;
% Iw = [ 0, Iw(2:N) ] ;
% Id = [ 0, Id(2:N) ] ;

if X == 1
	A = In(1) ;
	B = Iw(1) ;
	% In(1) = (2*pi*m)/N ;
	In(1) = In(1) * (1+m/(m+1)) ;
	% C=q/In(1);
	% In = In * C ;
	Iw(1) = (2*pi*m)/N ;
	A = In(1) - A ;
	B = Iw(1) - B ;
end

if X == 1
	% In(1)=2*pi*m/(N*(2*G-1));
	% Iw(1)=2*pi*m/(N*(2*G-1));
	In = [ 0, In(1:N-1) ] ;
	Iw = [ 0, Iw(1:N-1) ] ;
	Id = [ 0, Id(1:N-1) ] ;
else
	In(1)=0;
	Iw(1)=0;
end


if s == 's' | s == 'S'


	In = cumsum(In) ;
	Iw = cumsum(Iw) ;

	if X == 1
		In = In * (1-A/N) ;
		Iw = Iw * (1-B/N) ;
	end

	Id = Id/sum(Id) ;
	Id = cumsum(Id) ;
	% x=N;
end

% ----- plot responses -----
figure;
plot( t(1:x), Id(1:x), '-r', t(1:x), In(1:x), '-g', t(1:x), Iw(1:x), '-b' )

% ----- plot differences -----
figure;
plot( t(1:x), In(1:x)-Id(1:x), '-g', t(1:x), Iw(1:x)-Id(1:x), '-b' )

% Id(1), 2*In(1), 2*Iw(1)

