function fig641
% FIG641	Figure 641 for Part 6 (WXP) :
%			Complete 5th-order Butterworth system representation.
%			
%			Fig.6.3.1. Pole locations in complex plane
%			Fig.6.4.1. Magnitude over the complex plane

% RXon, 890112
% Last revision (Matlab-V) : 011226

[z,p]=buttap(5);	% a 5th order Butterworth system zeros and poles
[row,col]=size(p);


% -------------- Fig.6.3.1. ----------------- ;
% ----- cartesian-coordinates pole loci ----- ;
figh=figure(1) ;
P=[p(:).'; zeros(size( p(:).' ) )];
P=P(:);
theta=(0:pi/180:2*pi);
fill( [ -2, 0, 0, -2 -2 ], [ -2, -2, 2, 2, -2 ], [ 0.82, 0.82, 0.82 ] ) ;
hold on
axis('manual')
plot([-1.99,1.99],[0,0],'-k',...
     [0,0],[-1.99,1.99],'-k',...
     sin(0:pi/180:2*pi),cos(0:pi/180:2*pi),'-b',...
     real(P),imag(P),'-r',...
     real(p),imag(p),'*r')
axis('square')
axis([-2,2,-2,2]);
for kx = 1 : length(p)
	text( real(p(kx))-0.3, imag(p(kx))+0.2*sign(0.1+imag(p(kx))), ['{\itp}_', num2str(kx)],'FontSize',16 ) ;
end

axh=gca;
set(axh,'XTickMode','Manual','XTickLabelMode','Manual');
set(axh,'YTickMode','Manual','YTickLabelMode','Manual');
set(axh,'XTick',[-2,-1.5,-1,-0.5,0,0.5,1,1.5,2]);
set(axh,'YTick',[-2,-1.5,-1,-0.5,0,0.5,1,1.5,2]);
set(axh,'XTickLabel',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
set(axh,'YTickLabel',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
text(1.2,0.20,'\Re\{{\its}\}','FontSize',16)
text(0.1,1.75,'\Im\{{\its}\}','FontSize',16)
% title(['Fig. 6.4.',num2str(figh),'. :  5^{th}-order Butterworth Poles'])


% -------------- Fig.6.4.1. ---------------- ;
% ----- 3-D Magnitude over the s-plane ----- ;
figh=figure(figh+1) ;
% xyz( z, p, -2, 2, 12 ) ;
% xyz( Zeros, Poles, RealRange, ImagRange, HightRange, Resolution, MeshType, LabelFalg );
% xyz( z, p, -2, 2, 15, 50, 1, 0 ) ;
xyz( z, p, -2, 2, 15, 40, 1, 0 ) ;
axis([-2,0,-2,2,0,15]);
text( -1.4, 0.6, 15, '\uparrow\infty','FontSize',16 );
axh=gca;
set(axh,'ZTick',[0,5,10,15],'ZTickLabel',[' 0';' 5';'10';'15']);
text(-1,-3,-1,'{\it\sigma} = \Re\{{\its}\}','FontSize',16)
text(0,0,-2,'{\itj\omega} = {\itj}\Im\{{\its}\}','FontSize',16)
zlabel( '{\itM}({\its}) = |{\itF}({\its})|','FontSize',16)
% title( ['Fig. 6.4.',num2str(figh),'. :  5^{th}-order Butterworth Magnitude over {\its}-Plane'] )
% axis square
axis equal
