function fig6511
% FIG6511		Step responses of the 5th-order
%				Bessel-Thomson systems from 2nd
%				to 9th order with 1st-order ref.

% RXon, 880327
% Matlab-V revision : 001102

matver = version ;
matver = str2num( matver(1) ) ;

figure(1);
w=(0:1:255)/2;
for k = 1:1:9
	[z,p]=bestap(k,'t');
	H=freqw(z,p,w);
	if k == 1
		[S,t]=tresp(H,w,'s');
		x=min( find( t > 3 ) ) - 1 ;
		t=t(1:x);
	else
		S=tresp(H,w,'s');
	end		
	S=S(1:x);
	q=find(S<0);
	if ~isempty(q)
		disp(['S(',num2str(k),') < 0 between ',num2str(min(q))', ' and ', num2str(max(q)), '   min(S) = ', num2str(min(S))]);
	end
	if k > 1
		plot(t,S,'-b');
	else
		plot(t,S,'-g');
	end
	hold on
end

if matver == 4
	text( 1.35, -0.12, 'Time' )
	text( 0.4, 1.26, 'Fig.6.6.: Bessel systems of order 1 to 10' )
else
	xlabel( 'Time' )
%	title( 'Fig.6.5.11 : Bessel systems of order 2 to 9' )
end
if matver == 5
	axis([0,3,0,1.2]);
end

text( 0.20, 0.25, '1' );
text( 0.30, 0.18, '2' );
text( 0.75, 0.12, '9' );
