function y=fgs(f,g,s)
%FGS	Frequency, Gain, Slope.
%	
%	Use :	y=fgs(f,g,s)
%	
%	If f=[f1 f2] in Hz and g=[g1 g2] in dB and s is not specified,
%	then y will be the slope of the freq. resp. in dB/10f.
%	
%	If f=f1 and g=[g1 g2] and s is N db/10f, y will be f2.
%	
%	If f=[f1 f2] and g=g1 and s is N db/10f, y will be g2.
%	
%	Formula :
%			s=(g2-g1)/log10(f2/f1)


%	Erik Margan, *921105*

nf=max(size(f));
ng=max(size(g));
if nargin == 2
	if nf~=2 | ng~=2
		disp(['f = ', f(:).'])
		disp(['g = ', g(:).'])
		disp('???????')          
		error('Bad input argument number!')
	end
%	disp('Slope')
	y=(g(2)-g(1))/log10(f(2)/f(1));
pause
elseif nargin == 3
	if nf == 1 & ng == 2
%		disp('f2')
		y=f*10^((g(2)-g(1))/s);
	elseif nf == 2 & ng == 1
%		disp('g2')
		y=g+s*log10(f(2)/f(1));
	else
		disp(['f = ', f(:).'])
		disp(['g = ', g(:).'])
		disp(['s = ', s(:).'])
		disp('???????')          
		error('Bad input argument number!')
	end
end
