function fig62
% FIG62 ... CH-6 Fig.6.2. generation.
% 	The Negative-Frequency concept presented. The sum of a
%	complex-conjugate pair of half-amplitude phasors is equal
%	to the real-axis projection (it's cosine) of a single
%	complex full-amplitude phasor.

% RXon, 000213

phi = ( 0 : pi/180 : 2*pi ) ;
alpha = pi * 30 / 180 ;

plot([-1,1],[0,0],'-k',[0,0],[-1,1],'-k',...
	sin(phi),cos(phi),'-b',...
	[0,cos(alpha)],[0,sin(alpha)],'-r',...
	cos(alpha)*[1,1], [0,sin(alpha)],'--k',...
	[0,0.5*cos(alpha)],[0,0.5*sin(alpha)],'-g',...
	[0,0.5*cos(-alpha)],[0,0.5*sin(-alpha)],'-g',...
	cos(alpha)*[0.5,1],[0.5*sin(alpha),0],'--g',...
	cos(-alpha)*[0.5,1],[0.5*sin(-alpha),0],'--g')
axis('square');
text( cos(alpha), 0.05+sin(alpha), 'A' ) ;
text( cos(alpha), -0.05, 'B' ) ;
text( -0.05+0.5*cos(alpha), 0.05+0.5*sin(alpha), 'C' ) ;
text( 0.5*cos(alpha), -0.05-0.5*sin(alpha), 'D' ) ;
text( -0.08, 0.05, 'O' ) ;