function fig74
%FIG74	Generate Fig.7.4.1-3 for WBAmps, Part 7.
%
%	Show spectrum analysis and multiplication in frequency domain
%	as a substitute for convolution.

% RXon, 000402

f0=1000;			% frequency denormalization factor ;
[z,p]=buttap(3);		% 3rd-order Butterworth system ;
p=p*f0;				% half-power bandwidth is 1kHz ;

N=1024;				% total vector length ;
m=64/f0;			% frequency scaling factor
w=(0:1:N-1)/m;			% frequency vector ;
F=freqw(z,p,w);			% frequency response ;

dt=2*pi*m/N;			% delta-t ;
t=dt*(0:1:N-1);			% time vector ;

T=15*dt;			% input signal exponential decay time ;
f=1/(15*dt);			% input signal frequency ;
g=exp(-t/T).*sin(2*pi*t*f);	% input function in time domain ;
g=[g(1:N/2) -g(1:N/2)];		% the signal repeats every N/2 with opposite phase ;

figure(1)
x=max(find(t<=0.4));
plot( t(1:x), g(1:x) )
xlabel('Time')
title('Input signal')

G=fft(g);			% G is spectrum of g ;

Y=F.*G;				% output spectrum ;
				% multiplication in frequency equals convolution in time ;

figure(2)
x=max(find(w<=5000));
M=max(abs(G));
plot( w(1:x), abs(G(1:x))/M, '-r', ...
      w(1:x), abs(F(1:x)), '-g', ...
      w(1:x), abs(Y(1:x))/M, '-b' )
xlabel('Frequency')
title('Input Spectrum, System Response and Output Spectrum')

y=2*real(fft(conj(Y/N)));	% return to time domain and show result ;

figure(3)
x=max(find(t<=0.05));
plot( t(1:x), g(1:x), '-r', t(1:x), y(1:x), '-b' )
xlabel('Time')
title('Input and Output Signals')

