function fa=alias(fs,fc,phi)
% ALIAS

% RXon, 920807

if nargin < 3
    phi = pi/3 ;    % signal phase shift re. clk, arbitrary value
end
ofs = 2 ;           % clock offset
A = 1/ofs ;         % clock amplitude

m = 100 ;           % signal reconstruction factor equals
                    % number of dots within a clock period
N = 1 + 10 * m ;    % total number of dots
dt = 1 / ( m * fc ) ;   % delta-t for time reconstruction
t = dt * ( 0 : 1 : N ) ;    % time

fa = fs - fc ;      % alias frequency (can be negative!)
                    % clock reconstruction :
clk = ofs + A * sign( sin( 2 * pi * fc *t ) ) ;
                    % sampled signal :
sig = sin( 2 * pi * fs * t + phi ) ;
                    % alias signal :
sal = sin( 2 * pi * fa * t + phi ) ;

plot( t, clk, '-g',...
      t, sig, '-b',...
      t, sal, '-r',...
      t(1:m:N), sig(1:m:N), 'or')
xlabel( 't' )
axis([t(1),t(N),-1.5,3.0]);

