function Xf=convmovie
% CONVMOVIE  Convolution Demo Movie.
%            The step response of a Bessel 2nd-order system
%            is fed to a Butterworth 2nd-order system.
%            The resulting output is the convolution of the
%            Bessel system output with the impulse-response
%            of the Butterworth system.

% RXon, 001219

fig=figure;
set(fig,'DoubleBuffer','on');
set(gca,'xlim',[-80 80],'ylim',[-80 80],...
        'NextPlot','replace','Visible','off')
       
ptx=0.05;   % pause time between drawings

[z1,p1]=bestap(2,'t');
[z2,p2]=buttap(2);

T=20;
N=200;
t=(0:1:N)/T;
dt=t(2);
zt=zeros(1,length(t));

y1=atdr(z1,p1,t,'s');
y2=atdr(z2,p2,t,'i');
% y2=atdr(z2,p2,t,'n');

% y2=y2/sum(y2);
R=sum(y2);

plot3(             t,         y1,            zt, '-b',...
                   t,         y2,            zt, '-g',...
               [0,0], [-0.2,1.2],        [0, 0], '-k',...
              [0, 0],      [0,0],     [0, t(N)], '-k',...
       [-t(N), t(N)],      [0,0],         [0,0], '-k');
view( 0, 90 );

title( '1st-stage step- and 2nd-stage impulse-response' )
xlabel('Press any key to run ...')

if nargout
    xx = 1 ;
    Xf(xx) = getframe ;
end

pause

xlabel( ' ' );

h=y2(N+1:-1:1);
tn=-t(N+1:-1:1);

az=-20;
el=30;
M=100;
for k=0:1:M
    view( az*k/M, 90-el*k/M );
    drawnow;
    if nargout
        xx=xx+1;
        Xf(xx) = getframe ;
    end
    pause(ptx);
end
pause(0.5);

M=100;
for k = 0:1:M
    pause(ptx);
	ph0=plot3( -t*cos(pi*(M-k)/M),         y2, t*sin(pi*(M-k)/M), '-g',...
	                            t,         y1,                zt, '-b',...
	                        [0,0], [-0.2,1.2],            [0, 0], '-k',...
	                 [-t(N),t(N)],     [0, 0],            [0, 0], '-k',...
	                       [0, 0],     [0, 0],         [0, t(N)], '-k');
    view( az, 90-el );
    xlabel('Convolving the impulse response...')
	drawnow;
    if nargout
        xx=xx+1;
        Xf(xx) = getframe ;
    end
end
pause(0.5);

xlabel( ' ' );

M=100;
for k=M:-1:0
    view( -20*k/M, 90-18*k/M );
    drawnow;
    if nargout
        xx=xx+1;
        Xf(xx) = getframe ;
    end
    pause(ptx);
end

xlabel('Press any key to continue...')
pause

delete(ph0);
ph1=plot(           tn,          h, '-g',...
                     t,         y1, '-b',...
                 [0,0], [-0.2,1.2], '-k',...
          [-t(N),t(N)],     [0, 0], '-k' );
hold on;
xlabel( 'Time [s]' );
if nargout
    xx=xx+1;
    Xf(xx) = getframe ;
end

delete(ph1(1));
M=100;
k=1;

tk=tn-tn(N+2-k*N/M);
lh1=line( tk, h );
set( lh1, 'Color', 'g', 'LineStyle', '-' );
x=find( tk > 0 );
if isempty(x)
	x=1;
end
c=h(x).*y1(1:length(x));
sh1=fill( [tk(x), tk(x(length(x)))], [c, 0], 'r' ) ;
v=[0, sum(c)/R];
w=[0, tk(x(length(x)))];
lh2=line( w, v );
set(lh2, 'Color', [0.7,0,0], 'LineStyle','-','LineWidth',3 );
drawnow;
if nargout
    xx=xx+1;
    Xf(xx) = getframe ;
end

for k = 2:M
    pause(ptx);
	delete( lh1, sh1 );
	tk=tn-tn(N+2-k*N/M);
	lh1=line( tk, h );
	set( lh1, 'Color', 'g', 'LineStyle', '-' );
	x=find( tk > 0 );
	c=h(x).*y1(1:length(x));
	sh1=fill( [tk(x), tk(x(length(x)))], [c, 0], 'r' ) ;
	v=[v(2), sum(c)/R];
	w=[w(2), tk(x(length(x)))];
	lh2=line( w, v );
	set(lh2, 'Color', [0.7,0,0], 'LineStyle','-','LineWidth',3 );
	drawnow;
    if nargout
        xx=xx+1;
        Xf(xx) = getframe ;
    end
end
xlabel('Time');
if nargout
    xx=xx+1;
    Xf(xx) = getframe ;
end

if nargout
    movie2avi( Xf, 'convmovie' );
    % matrix2avi( Xf, ['file','convmovie'] );
end


    