% Gated 1.5kHz sinewave into a 5th-order 1kHz Butterworth system ;
% Script ;
% Call :         gated_b5 ;

% author : E.Margan, 1988.12.11.
% No copyright protection applied !

 fh=1000;			% system half-power bandwidth, 1kHz
 fs=1500;			% input signal frequency, 1.5kHz
 t=(0:1:300)/(50*fh);	% time vector, 20us delta-t, 6ms range
 nt=length(t);

 [z,p]=buttap(5);		% 5th-order Butterworth system
 p=2*pi*fh*p;		% denormalized system poles
 h=atdr(z,p,t,'n');	% system impulse-response

 d=25;			% switch-on delay, 25 time-samples
				% make the input signal :
 x=[zeros(1,d), sin(2*pi*fs*t(1:nt-d))];

 y=vcon(h,x);		% convolve x with h ;

 A=nt/(2*pi*fh*max(t));	% denormalize amplitude of h for plot
				% plot input, system i.r. and convolution result
 figure(1)
 plot( t*fh, x, '-g', ...
       t*fh, [zeros(1,d), h(1:nt-d)*A],'-r', ...
       t*fh, y(1:nt), '-b')
 xlabel('Time [ms]')

% calculation of the step-response :  
 x=[zeros(1,d) ones(1,nt-d)];			% input unit-step function
 y=vcon(h,x);					% convolution
 
 figure(2)
 plot( t*fh, x, '-g', ...
       t*fh, [zeros(1,d), h(1:nt-d)*A],'-r', ...
       t*fh, y(1:nt), '-b')
 xlabel('Time [ms]')
