function tline(d,w,h,l,b,x,k,etar)
% TLINE ...Transmission LINE design aid. Meandre form is assumed.
%       Call :
%               tline(d,w,h,l,b,x,k,etar);
%       where:  
%               d <-- distance between upper and lower track [mm]
%               w <-- track width                            [mm]
%               h <-- trach hight                            [mm]
%               l <-- track length                           [mm]
%               b <-- track spacing                          [mm]
%               x <-- transversal line length                [mm]
%               k <-- coupling factor                        
%            etar <-- relative dielectric constant           

%       Erik Margan, *940420*

d=1e-3*d;
w=1e-3*w;
h=1e-3*h;
l=1e-3*l;
b=1e-3*b;
x=1e-3*x;

disp(['    d = ', num2str(d)]);
disp(['    w = ', num2str(w)]);
disp(['    h = ', num2str(h)]);
disp(['    l = ', num2str(l)]);
disp(['    b = ', num2str(b)]);
disp(['    x = ', num2str(x)]);


if k <= 1 | k >= 2
        error('Coupling coefficient must be 1 < k < 2 ; typ.: k=1.95 !');
end
if w < 10*h
        error('Track width w must be greater than 10*h !');
end
if d < 3*h
        error('Track distance d must be greater than 3*h !');
end
if b > x/20
        error('Track spacing b too high !');
end
if b < w/2  | b > 5*w
        error('Track spacing b must be w/2 < b < 5*w !');
end

% constants :
mu0=pi*4e-7;            % [Vs/Am]
mur=1;
eta0=8.85e-12;          % [As/Vm]

% approx. impedance of the single track element cross-section :
zo=(377/sqrt(etar))*(d/w);

% approx. line capacitance and inductance of a single track element :
co=eta0*etar*w*l/d;
lo=co*zo^2;

disp(' ');
disp('   zo [ohm]    co [pF]    lo [nH] ');
disp('--------------------------------');
disp([zo, co*1e+12, lo*1e+9]);
disp(' ');

% geometry factor for meandre configuration :
gf=2*k;
Lo=gf*lo;
Co=co;
Zo=sqrt(Lo/Co);

disp(' ');
disp('   Zo [ohm]    Co [pF]    Lo [nH] ');
disp('----------------------------------');
disp([Zo, Co*1e+12, Lo*1e+9]);
disp(' ');

% propagation speed :
vp=1/sqrt(Lo*Co);
% total line length :
s=l*floor(x/b);
% total time delay :
taud=s/vp;
c=1/sqrt(mu0*eta0);

disp(' ');
disp(' c [mm/ns]  v [mm/ns]  taud [ns] ');
disp('---------------------------------');
disp([c*1e-6,vp*1e-6, taud*1e+9]);

% check inductance calculation :
Lx=1e-8*1e-2*b*l*gf;

disp(' ');
disp('   Lo [nH]      Lx [nH]    ');
disp('---------------------------');
disp([Lo*1e+9, Lx*1e+9]);
disp(' ');
