function sinmovie(w)
% SINMOVIE	Sine-wave movie.
%				A sine-wave as a projection of a rotating phasor.
%				Experimental.

% RXon, 000923

if ~nargin
	w = 1 ;
end

hfig=figure(1);

delta_phi = 1 ;		% 1 degree
phi = 2 * pi * ( 0 : delta_phi : 360 ) / 360 ;
x = cos( phi ) ;
y = sin( phi ) ;

plot( [ -pi/2, 5*pi/2 ], [ 0, 0 ],        '-k', ...
      [ 0, 0 ],          [ -1.75, 1.75 ], '-k', ...
      -1.9,              -3.9,            '.w', ...
      7.9,               3.9,             '.w' )
drawnow;
hold on
pause(1)
k = 1 ;
lh2 = line( [0,x(k)], [0,0], 'Color','c', 'LineStyle','-','EraseMode','xor' ) ;
drawnow;
pause(1)

delete( lh2 ) ;
k = 2 ;
lh1 = line( [0,x(k)], [0,y(k)], 'Color','r', 'LineStyle','-','EraseMode','xor' ) ;
lh2 = line( [0,x(k)], [0,0], 'Color','c', 'LineStyle','-','EraseMode','xor' ) ;
lh3 = line( [x(k),x(k)], [0,y(k)], 'Color','r', 'LineStyle','-','EraseMode','xor' ) ;
lh4 = line( [x(k-1),x(k)], [y(k-1),y(k)], 'Color','g','LineStyle','-','EraseMode','xor' ) ;
lh5 = line( [phi(k-1), phi(k)], [y(k-1), y(k)], 'Color','b', 'LineStyle','-','EraseMode','xor' ) ;
lh6 = line( [phi(k), phi(k)], [0,y(k)], 'Color','r', 'LineStyle','-','EraseMode','xor' ) ;
lh7 = line( [x(k),phi(k)], [y(k),y(k)], 'Color','m', 'LineStyle',':','EraseMode','xor' ) ;
drawnow;

for k = 3 : length( phi )

	delete( lh1 ) ;
	delete( lh2 ) ;
	delete( lh3 ) ;
	delete( lh6 ) ;
	delete( lh7 ) ;
	
	lh1 = line( [0,x(k)], [0,y(k)], 'Color','r', 'LineStyle','-','EraseMode','xor' ) ;
	lh2 = line( [0,x(k)], [0,0], 'Color','c', 'LineStyle','-','EraseMode','xor' ) ;
	lh3 = line( [x(k),x(k)], [0,y(k)], 'Color','r', 'LineStyle','-','EraseMode','xor' ) ;
	lh4 = line( [x(k-1),x(k)], [y(k-1),y(k)], 'Color','g','LineStyle','-','EraseMode','xor' ) ;
	lh5 = line( [phi(k-1), phi(k)], [y(k-1), y(k)], 'Color','b', 'LineStyle','-','EraseMode','xor' ) ;
	lh6 = line( [phi(k), phi(k)], [0,y(k)], 'Color','r', 'LineStyle','-','EraseMode','xor' ) ;
	lh7 = line( [x(k),phi(k)], [y(k),y(k)], 'Color','m', 'LineStyle',':','EraseMode','xor' ) ;

end
lh2 = line( [0,x(k)], [0,0], 'Color','r', 'LineStyle','-','EraseMode','xor' ) ;
