function compfilt(N)
%COMPFILT COMPFILT(N)  will compare  three different  N-th order all-poles
%	  filter types: Butterworth, Bessel-Thomson, and Chebyschew.
%
%	  COMPFILT by itself allows comparison of different order filters.
%
%	  See also FAMILY and SYSVIEW.

%	  Erik Margan, October 19, 1988
%	  Jozef Stefan Institute, Ljubljana, Slovenia
%	  Last revision : May 8th, 1992

clc;
if nargin == 1
	N=fix(abs(N(1,1)));
	N1=N;
	N2=N;
	N3=N;
else
	N1=input('Enter Butterworth filter order     [ CR=5 ] : ');	
	N2=input('Enter Bessel-Thomson filter order  [ CR=5 ] : ');
	N3=input('Enter Chebyschew filter order      [ CR=5 ] : ');
	if isempty(N1)==1, N1=5;,end
	if isempty(N2)==1, N2=5;,end
	if isempty(N3)==1, N3=5;,end
        N1=fix(abs(N1(1,1)));
	N2=fix(abs(N2(1,1)));
	N3=fix(abs(N3(1,1)));
end
r=input('Enter allowable Chebyschew passband ripple in dB [ CR=.5dB ] : ');
if isempty(r)==1
	r=.5;
end
if N1<2 | N2<2 | N3<2
	disp('WARNING : First order filters are equal for all types !');
end
w=logspace(-1,1,200);
[z,but]=buttap(N1);
[z,bes]=bestap(N2,'n');
[z,che]=cheb1np(N3,r,-3);
clc

disp('Calculating frequency responses...');
Fbut=freqw(but,w);
Fbes=freqw(bes,w);
Fche=freqw(che,w);
Mbut=20*log10(abs(Fbut));
Mbes=20*log10(abs(Fbes));
Mche=20*log10(abs(Fche));
semilogx(w,Mbut,w,Mbes,w,Mche),title('Frequency responses')
 xlabel('Frequency')
 ylabel('Attenuation [dB]')
 pause
 clc

z=input('Zoom passband details? [Y/N; CR=Y] : ','s');
if isempty(z) == 1
	z='Y';
end
if z=='Y' | z=='y'
	at=input('Enter maximum attenuation in dB [ CR=3 ] : ');
	if isempty(at)==1
		at=3;
	end
	axis([-1 1 -at 1]);
	% semilogx(w,Mbut,w,Mbes,w,Mche),title('Zoomed passband details')
	% xlabel('Frequency')
	% ylabel('Attenuation [dB]')
	 pause
	% axis;
end
clc;
clear Mbut
clear Mbes
clear Mche

disp('Calculating phase shifts...');
Pbut=ephd(angle(Fbut));
Pbes=ephd(angle(Fbes));
Pche=ephd(angle(Fche));
PPbut=180*Pbut/pi;
PPbes=180*Pbes/pi;
PPche=180*Pche/pi;
semilogx(w,PPbut,w,PPbes,w,PPche)
 title('Phase shift')
 xlabel('Frequency')
 ylabel('Phase [Degrees]')
 pause
 clc
clear PPbut
clear PPbes
clear PPche

disp('Calculating envelope delays...');
deltaw=w(2:1:200)-w(1:1:199);
tdbut=(Pbut(2:1:200)-Pbut(1:1:199))./deltaw;
tdbes=(Pbes(2:1:200)-Pbes(1:1:199))./deltaw;
tdche=(Pche(2:1:200)-Pche(1:1:199))./deltaw;
tdbut=[tdbut 0];
tdbes=[tdbes 0];
tdche=[tdche 0];
semilogx(w,tdbut,w,tdbes,w,tdche)
 title('Envelope delay')
 xlabel('Frequency')
 ylabel('Normalized delay')
 pause
clc
clear Fbut
clear Fbes
clear Fche
clear Pbut
clear Pbes
clear Pche
clear deltaw
clear tdbut
clear tdbes
clear tdche

disp('Calculating impulse responses...');
w=(0:1:255);
w0=8;
w=w/w0;
nw=length(w);
a=10.23*(nw/256)*(4/w0);
xw=(1+cos(pi*(0:1:nw-1)/(nw-1)))/2;	% half-hanning window ;
z=[];
fbut=xw.*freqw(z,but,w);
fbut=(2*real(fft(conj(fbut)))-1)/nw;
fbut(1)=0;
fbes=xw.*freqw(z,bes,w);
fbes=(2*real(fft(conj(fbes)))-1)/nw;
fbes(1)=0;
fche=xw.*freqw(z,che,w);
fche=(2*real(fft(conj(fche)))-1)/nw;
fche(1)=0;

w=w0*w/5;	% Normalization of the time scale ;
xf=max(find(abs(fche) >= .1*max(fche)));
if 2*xf > nw
	xf=nw/2;
end
w=w(1:2*xf);
T=5;
xw=max(find(w==T*round(w/T)));
w=w(1:xw);
nw=length(w);

fbut=fbut(1:nw);
fbes=fbes(1:nw);
fche=fche(1:nw);

plot(w,a*fbut,w,a*fbes,w,a*fche)
 xlabel('Normalized time')
 title('Impulse responses')
 pause
clc
disp('Calculating step responses...');
fbut=cumsum(fbut);
fbes=cumsum(fbes);
fche=cumsum(fche);
fbut=(fbut-fbut(1))/(1-fbut(1));
fbes=(fbes-fbes(1))/(1-fbes(1));
fche=(fche-fche(1))/(1-fche(1));
plot(w,fbut,w,fbes,w,fche)
 xlabel('Normalized time')
 title('Step responses')
clc
