function [Rse,Rsh]=attpi(A,R0,inv)
%ATTPI	Pi-type chain attenuator series and shunt element determination from
%	single-section attenuation A in [dB] and characteristic impedance R0:
%	
%		[Rse,Rsh]=attpi(A,R0)
%	
%	Reversed calculation is performed if a third non-zero input argument
%	is entered.
%	
%		[A,R0]=attpi(Rse,Rsh,inv)
%

%	RXon, 890921

if nargin == 2
	A=-abs(A);
	A=10^(A/20);		% dB - to - factor conversion ;
	
	Rsh=R0*A/(1-A);
	Rse=R0*(1-A);

elseif nargin == 3
	Rse=1-2*A/(A+sqrt(A^2+4*R0*A));
	Rsh=.5*(A+sqrt(A^2+4*R0*A));
	if Rse > 1
		Rse=1/Rse;
	end
	Rse=20*log10(Rse);	% factor - to - dB conversion ;
end