function [z,p,k] = buttapx(n)
%BUTTAPX	Butterworth analog lowpass filter prototype (old version).
%	See BUTTAP (new version from Matlab-V Signal Processing Toolbox).
%	[Z,P,K] = BUTTAPX(N) returns the zeros, poles, and gain
%	for an N-th order normalized prototype Butterworth analog
%	lowpass filter.  The resulting filter has N poles around
%	the unit circle in the left half plane, and no zeros.
%
%	See also BUTTER, CHEB1AP, and CHEB2AP.

%	J.N. Little and J.O. Smith 1-14-87
%	Revised 1-13-88 LS
%	(c) Copyright 1987, 1988,  by The MathWorks, Inc.

% Poles are on the unit circle in the left-half plane.
z = [];
p = exp(sqrt(-1)*(pi*(1:2:2*n-1)/(2*n) + pi/2)).';
k = real(prod(-p));

