function q=expfit(X, fdata)
% EXPFIT fit exponential functions.
%        Call :
%					q=expfit(X, fdata);
%			where:
%           fdata :
%           = vector or 2-column matrix of data to
%             which the exponential function is fited.
%             Vector data are assumed to be index-equidistant.
%             For 2-column matrix, the first column is
%             assumed to be the argument values and the
%             second column the function values.
%           X :
%           = 2-element matrix X=[a,b] where
%             Y(X) = a * exp( -b * t )
%             and t = ( 1 : length( fdata ) ) if fdata is a vector
%             or  t = fdata(:,1) if fdata is a 2-column matrix.
%           q :
%           = the value returned by EXPFIT is calculated as :
%             q = norm( Y - fdata ) if fdata is a vector
%             q = norm( Y - fdata(:,2) ) if fdata is a 2-column matrix.
%
%         EXPFIT is called by FITX to perform iterative fiting.

% RXon, 010720

% check fdata size
[nrows, ncols]=size(fdata);
% force column-wise processing
if nrows < ncols
	fdata = fdata.' ;
end
% check if fdata is a vector or a 2-column matrix
if min( [nrows, ncols] ) == 1
	matrix_flag = 0 ;
	t = ( 1 : length( fdata ) ).' ;
else
	matrix_flag = 1 ;
	t = fdata( :, 1 ) ;
end

% check X size
if length( X ) ~= 2
	error( 'Bad input : X must be a 3-element vector !' ) ;
end

% make Y
Y = X(1) * exp( -X(2) * t ) ;

% calculate the missfit and return it to the calling function
if matrix_flag
	q = norm( Y - fdata(:,2) ) ;
else
	q = norm( Y - fdata ) ;
end
