function gndsch(x0,y0,ds)
% GNDSCH ... Ground circuit schematic plot.
%	     Used by "SCHEMA.M".
%	     Call :
%			gndsch(x0,y0,ds) ;
%		
%		where:
%			x0,y0 --> starting coordinates
%			   ds --> direction string ( 'u', 'd', 'l', 'r' )

% RXon, 000625

GX1=[0,1,1,1];
GY1=[0,0,0.75,-0.75];
GX2=[1.25,1.25];
GY2=[0.5,-0.5];
GX3=[1.5,1.5];
GY3=[0.25,-0.25];

if strcmp(ds,'l')
	GX1=-GX1;
	GX2=-GX2;
	GX3=-GX3;
elseif strcmp(ds,'d')
	tmp=GX1;
	GX1=GY1;
	GY1=-tmp;
	tmp=GX2;
	GX2=GY2;
	GY2=-tmp;
	tmp=GX3;
	GX3=GY3;
	GY3=-tmp;
elseif strcmp(ds,'u')
	tmp=GX1;
	GX1=GY1;
	GY1=tmp;
	tmp=GX2;
	GX2=GY2;
	GY2=tmp;
	tmp=GX3;
	GX3=GY3;
	GY3=tmp;
end

line(x0+GX1,y0+GY1,'Color',[0,0,0]);
line(x0+GX2,y0+GY2,'Color',[0,0,0]);
line(x0+GX3,y0+GY3,'Color',[0,0,0]);
