function C=linreg(y)
%LINREG		LINear REGression. If y is a vector, C=linreg(y) returns
%		the least-sqare-fit line coefficients so that C(1)*X+C(2)
%		fits data in y.
%		If Y is a matrix, contining two vectors [t, y], the fiting
%		is performed on y, but also taking t into account.

%	Erik Margan, *911029*

C=[0,0];
[ny,my]=size(y);
if my > ny
	y=y.';
	[ny,my]=size(y);
end
if my == 1
	t=0:1:ny-1;
	t=t(:);
elseif my == 2
	t=y(:,1);
	y=y(:,2);
else
	error('Input argument must be a N-by-1 vector or a N-by-2 matrix!')
end

sx=sum(t);
sx2=sum(t.^2);
sy=sum(y);
sy2=sum(y.^2);
sxy=sum(t.*y);

K=(sxy-(sx*sy)/ny)/(sx2-sx^2/ny);
L=sy/ny - K*sx/ny;
C=[K,L];
