function Rr=rratio(N1,N2)
% RRATIO ... Resistor ratio, closest standard E24 values.
%		Call :
%				Rr=rratio(N1,N2);
%
%		where : 	N1 = desired ratio or numerator
%					N2 = denominator (optional)
%					Rr = 4-column, x-row matrix :
%					Rr = [ R1, R2, R1/R2, Qx ]
%					R1 = closest E24 value of N1
%					R2 = closest E24 value of N2
%					R1/R2 = actual ratio
%					Qx = absolute error of the ratio = (R1/R2)-(N1/N2)
%
%		Note : More than one solution is possible.
%				 Ie., if N1/N2 = 2, Rr will have 6 rows.

% RXon, 020922

if nargin < 2
	N2 = 1 ;
end

m = 0 ;
N3 = 0 ;
if ( N1 < N2 )
	N3 = N2 ;
	N2 = N1 ;
	N1 = N3 ;
end
while ( N1 / N2 ) > 10
	m = m+1 ;
	N1 = N1 / 10^m ;
end

E24 = [       1.0 ; 1.1 ; 1.2 ; 1.3 ; 1.5 ; 1.6 ; 1.8 ] ;
E24 = [ E24 ; 2.0 ; 2.2 ; 2.4 ; 2.7 ; 3.0 ; 3.3 ; 3.6 ] ;
E24 = [ E24 ; 3.9 ; 4.3 ; 4.7 ; 5.1 ; 5.6 ; 6.2 ; 6.8 ] ;
E24 = [ E24 ; 7.5 ; 8.2 ; 9.1 ] ;

E72 = [ 0.1 * E24 ; E24 ; 10 * E24 ] ;
for k = 1 : 24
	Q(:,k) = E72 / E24(k) ;
end

M = abs( Q - N1/N2 ) ;
Qx = min( min( M ) ) ;

[x,y] = find( M == Qx ) ;

R1 = E72(x) ;
R2 = E24(y) ;
R1 = R1 * 10^m ;

if N3 ~= 0
	N3 = R1 ;
	R1 = R2 ;
	R2 = N3 ;
end

[ row, col ] = size( R1 ) ;
Qx = Qx * ones( row, col ) ;
Rr=[R1,R2,R1./R2,Qx];
