function fh=schema(ftype)
% SCHEMA ... Circuit schematic plot of several filter types.
%	     Used by "AFS.M".
%	     Call :
%			fh=schema(ftype) ;
%		
%		where:     fh <-- returned figure handle
%			    ftype --> filter type flag :
%				  1 :  Sallen-Key (non-inverting)
%				  2 :  Equal-RC Sallen-Key (non-inverting)
%				  3 :  Multiple-Feedback (order-dependent inverting)
%				  4 :  ---
%				  5 :  ---

% RXon, 000625

if ~nargin
	ftype = 1 ;
end

fh=gcf;
axh=gca;
axis('equal');
set(axh,'XColor',[1,1,1]);
set(axh,'YColor',[1,1,1]);
set(axh,'ZColor',[1,1,1]);

if ftype == 1
	% graph scale change - plot a far invisible object :
	line([0,32],[1,32],'Color', [1,1,1]);
	text(2,32, 'Sallen-Key filters of 1st-, 2nd- and 3rd-order') ;

	% ----- 1st-order SK ------ ;

	% R1, hor. :
	R1=rsch(0,20,'r','R1');

	% Dot at the input node :
	% dotsch(R1(1),R1(2));

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, ver. :
	C1=capsch(R1(3),R1(4),'d','C1');

	% GND at the end of C1 :
	gndsch(C1(3),C1(4),'d');

	% Op-Amp at the R1-C1 node :
	A1=opampsch(R1(3),R1(4),'r',1,1,'A1');

	% ----- 2nd-order SK ----- ;

	% R2, hor. :
	R2=rsch(20,20,'r','R2');

	% Dot at the R2-C2 node :
	dotsch(R2(3),R2(4));

	% line from R2 end to C2 (R2y+1) :
	line( [R2(3), R2(3)], [R2(4), R2(4)+1], 'Color', [0,0,0] );

	% C2, ver. :
	C2=capsch(R2(3),R2(4)+1,'u','C2');

	% R1, hor. :
	R1=rsch(R2(3),R2(4),'r','R1');

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, ver. :
	C1=capsch(R1(3),R1(4),'d','C1');

	% GND at the end of C1 :
	gndsch(C1(3),C1(4),'d');

	% Op-Amp at the R1-C1 node :
	A2=opampsch(R1(3),R1(4),'r',1,1,'A2');

	% C2 end to inv.input of opamp :
	line( [C2(3),A2(3)],[C2(4),C2(4)],'Color', [0,0,0] );
	% dot at the connection node :
	dotsch( A2(3), C2(4) ) ;

	% ----- 3rd-order SK ----- ;

	% R3, hor. :
	R3=rsch(0,0,'r','R3');

	% C3, ver. :
	C3=capsch(R3(3),R3(4),'d','C3');

	% Dot at the R3-C3 node :
	dotsch(R3(3),R3(4));

	% GND at the end of C3 :
	gndsch(C3(3),C3(4),'d');

	% R2, hor. :
	R2=rsch(R3(3),R3(4),'r','R2');

	% Dot at the R2-C2 node :
	dotsch(R2(3),R2(4));

	% line from R2 end to C2 (R2y+1) :
	line( [R2(3), R2(3)], [R2(4), R2(4)+1], 'Color', [0,0,0] );

	% C2, ver. :
	C2=capsch(R2(3),R2(4)+1,'u','C2');

	% R1, hor. :
	R1=rsch(R2(3),R2(4),'r','R1');

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, ver. :
	C1=capsch(R1(3),R1(4),'d','C1');

	% GND at the end of C1 :
	gndsch(C1(3),C1(4),'d');

	% Op-Amp at the R1-C1 node :
	A3=opampsch(R1(3),R1(4),'r',1,1,'A3');

	% C2 end to inv.input of opamp :
	line( [C2(3),A3(3)],[C2(4),C2(4)],'Color', [0,0,0] );
	% dot at the connection node :
	dotsch( A3(3), C2(4) ) ;

elseif ftype == 2
	% graph scale change - plot a far invisible object :
	line([0,33],[1,33],'Color', [1,1,1]);
	text(-3,33, 'Equal-RC Sallen-Key filters of 1st-, 2nd- and 3rd-order') ;

	% ----- 1st-order EqSK ------ ;

	% R1, hor. :
	R1=rsch(0,20,'r','R');

	% Dot at the input node :
	% dotsch(R1(1),R1(2));

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, ver. :
	C1=capsch(R1(3),R1(4),'d','C');

	% GND at the end of C1 :
	gndsch(C1(3),C1(4),'d');

	% Op-Amp at the R1-C1 node :
	A1=opampsch(R1(3),R1(4),'r',1,1,'A1');

	% ----- 2nd-order EqSK ----- ;

	% R2, hor. :
	R2=rsch(20,20,'r','R');

	% Dot at the R2-C2 node :
	dotsch(R2(3),R2(4));

	% C2, ver. :
	C2=capsch(R2(3),R2(4),'d','C');

	% R1, hor. :
	R1=rsch(R2(3),R2(4),'r','R');

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, ver. :
	C1=capsch(R1(3),R1(4),'d','C');

	% GND at the end of C1 :
	gndsch(C1(3),C1(4),'d');

	% Op-Amp at the R1-C1 node :
	A2=opampsch(R1(3),R1(4),'r',1,0,'A2');
	
	% Feedback, Re and Rf :
	line( [A2(5),A2(5),A2(5)-3 ], [A2(6),A2(6)+6,A2(6)+6 ], 'Color', [0,0,0] );
	Rf=rsch(A2(5)-3,A2(6)+6,'l','Rf');
	line( [Rf(3), A2(3)], [Rf(4), A2(4)], 'Color', [0,0,0] );
	dotsch( Rf(3), Rf(4) ) ;
	Re=rsch( Rf(3), Rf(4), 'l', 'Re' );
	gndsch( Re(3), Re(4), 'd' ) ;
	
	% C2 end to inv.input of opamp :
	line( [C2(3),C2(3),A2(5),A2(5)],[C2(4),C2(4)-3,C2(4)-3,A2(6)],'Color', [0,0,0] );
	% dot at the connection node :
	dotsch( A2(5), A2(6) ) ;

	% ----- 3rd-order EqSK ----- ;

	% R3, hor. :
	R3=rsch(0,-2,'r','R');

	% Dot at the R3-C3 node :
	dotsch(R3(3),R3(4));

	% C3, ver. :
	C3=capsch(R3(3),R3(4),'d','C');

	% GND at the end of C1 :
	gndsch(C3(3),C3(4),'d');

	% R2, hor. :
	R2=rsch(R3(3), R3(4),'r','R');

	% Dot at the R2-C2 node :
	dotsch(R2(3),R2(4));

	% C2, ver. :
	C2=capsch(R2(3),R2(4),'d','C');

	% R1, hor. :
	R1=rsch(R2(3),R2(4),'r','R');

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, ver. :
	C1=capsch(R1(3),R1(4),'d','C');

	% GND at the end of C1 :
	gndsch(C1(3),C1(4),'d');

	% Op-Amp at the R1-C1 node :
	A3=opampsch(R1(3),R1(4),'r',1,0,'A3');
	
	% Feedback, Re and Rf :
	line( [A3(5),A3(5),A3(5)-3 ], [A3(6),A3(6)+6,A3(6)+6 ], 'Color', [0,0,0] );
	Rf=rsch(A3(5)-3, A3(6)+6,'l','Rf');
	line( [Rf(3), A3(3)], [Rf(4), A3(4)], 'Color', [0,0,0] );
	dotsch( Rf(3), Rf(4) ) ;
	Re=rsch( Rf(3), Rf(4), 'l', 'Re' );
	gndsch( Re(3), Re(4), 'd' ) ;
	
	% C2 end to inv.input of opamp :
	line( [C2(3),C2(3),A3(5),A3(5)],[C2(4),C2(4)-3,C2(4)-3,A3(6)],'Color', [0,0,0] );
	% dot at the connection node :
	dotsch( A3(5), A3(6) ) ;
elseif ftype == 3
	% graph scale change - plot a far invisible object :
	line([0,30],[1,30],'Color', [1,1,1]);
	text(-3,30, 'Multiple-Feedback filters of 1st-, 2nd- and 3rd-order') ;

	% ----- 1st-order MFB ------ ;

	% R1, hor. :
	R1=rsch(0,20,'r','R1');

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, ver. :
	C1=capsch(R1(3),R1(4),'r','C1');

	line( [R1(3), R1(3)], [R1(4), R1(4)-4], 'Color', [0,0,0] );
	line( [R1(3), R1(3)], [R1(4), R1(4)+4], 'Color', [0,0,0] );

	% Op-Amp (inv.input) at the R1-C1 node :
	A1=opampsch(R1(3),R1(4)-8,'r',1,0,'A1');
	% GND at the non-inv.input of A1 :
	gndsch(A1(1),A1(2),'d');
	
	R2=rsch( R1(3), R1(4)+4, 'r', 'R2' );

	line( [R2(3), A1(5), A1(5)], [R2(4), R2(4), A1(6)], 'Color', [0,0,0] );
	line( [C1(3), A1(5)], [C1(4), C1(4)], 'Color', [0,0,0] );
	dotsch( A1(5), C1(4) ) ;

	% ----- 2nd-order MFB ------ ;

	% R3, hor. :
	R3=rsch(20, 20,'r','R3');

	% Dot at the R3-C2 node :
	dotsch(R3(3),R1(4));

	% C2, ver. :
	C2=capsch(R3(3),R3(4),'d','C2');
	% GND at the end of C2 :
	gndsch(C2(3),C2(4),'d');

	% R1, hor. :
	R1=rsch(R3(3),R3(4),'r','R1');

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, hor. :
	C1=capsch(R1(3),R1(4),'r','C1');

	line( [R1(3), R1(3)], [R1(4), R1(4)-4], 'Color', [0,0,0] );
	line( [R3(3), R3(3), R1(3)], [R3(4), R3(4)+4,R3(4)+4], 'Color', [0,0,0] );


	% Op-Amp (inv.input) at the R1-C1 node :
	A2=opampsch(R1(3),R1(4)-8,'r',1,0,'A2');
	% GND at the non-inv.input of A2 :
	gndsch(A2(1),A2(2),'d');
	
	R2=rsch( R1(3), R1(4)+4, 'r', 'R2' );

	line( [R2(3), A2(5), A2(5)], [R2(4), R2(4), A2(6)], 'Color', [0,0,0] );
	line( [C1(3), A2(5)], [C1(4), C1(4)], 'Color', [0,0,0] );
	dotsch( A2(5), C1(4) ) ;

	% ----- 3rd-order MFB ------ ;

	% R4, hor. :
	R4=rsch(0, 0,'r','R4');
	% Dot at the R4-C3 node :
	dotsch(R4(3),R4(4));
	% C3, ver. :
	C3=capsch(R4(3),R4(4),'d','C3');
	% GND at the end of C3 :
	gndsch(C3(3),C3(4),'d');

	% R3, hor. :
	R3=rsch(R4(3), R4(4),'r','R3');

	% Dot at the R3-C2 node :
	dotsch(R3(3),R3(4));

	% C2, ver. :
	C2=capsch(R3(3),R3(4),'d','C2');
	% GND at the end of C2 :
	gndsch(C2(3),C2(4),'d');

	% R1, hor. :
	R1=rsch(R3(3),R3(4),'r','R1');

	% Dot at the R1-C1 node :
	dotsch(R1(3),R1(4));

	% C1, hor. :
	C1=capsch(R1(3),R1(4),'r','C1');

	line( [R1(3), R1(3)], [R1(4), R1(4)-4], 'Color', [0,0,0] );
	line( [R3(3), R3(3), R1(3)], [R3(4), R3(4)+4,R3(4)+4], 'Color', [0,0,0] );


	% Op-Amp (inv.input) at the R1-C1 node :
	A3=opampsch(R1(3),R1(4)-8,'r',1,0,'A3');
	% GND at the non-inv.input of A3 :
	gndsch(A3(1),A3(2),'d');
	
	R2=rsch( R1(3), R1(4)+4, 'r', 'R2' );

	line( [R2(3), A3(5), A3(5)], [R2(4), R2(4), A3(6)], 'Color', [0,0,0] );
	line( [C1(3), A3(5)], [C1(4), C1(4)], 'Color', [0,0,0] );
	dotsch( A3(5), C1(4) ) ;

% elseif ftype == 4
end


% graph scale change - plot a far invisible object :
% line([40,41],[40,41],'Color', [1,1,1]);
