function [x,t]=sinexp(n,f0,d,T,m)
%SINEX	...a SINe wave with EXponential decay.
%       Usefull for test-data generation.
%
%   Call :  [x,t]=sinex(n,f0,d,T,m);
%   where:  n --> total number of samples in the t vector
%           f0--> characteristic frequency
%           d --> decay exponent
%           T --> number of time samples in a time unit
%           m --> time exponent (default 0)
%
%           t <-- time scale t=(0:1:n-1)/T
%           x <-- the constructed signal

%	RXon, 890712, last revision 010315
%	Not copyright protected !

if nargin < 5
    m=0;
end
if nargin < 4
    if ~nargin
        n=300;
    end
    T=n/5;
end
if nargin < 3
    d=pi;
end
if nargin < 2
    f0=1;
end
if ~nargin
    n=300;
end

t=(0:1:n-1)/T;
x=(t.^m).*(sin(2*pi*f0*t)).*exp(-d*t);