function [Re,Rf]=stdr(x,str)
% STDR ... STanDard Ratio of component values in E12, E24, E48 and E96 scale.
%
%	Call :		v = stdr( x, 'E24' ) ;

% RXon, 990218

if nargin == 1
	str = 'E24' ;
end

E12 = [1;1.2;1.5;1.8;2.2;2.7;3.3;3.9;4.7;5.6;6.8;8.2];

E24 = [1.1;1.3;1.6;2.0;2.4;3.0;3.6;4.3;5.1;6.2;7.5;9.1];
E24 = [E12(:)';E24(:)'];
E24 = E24(:);
%E48
%E96

invertx = 0 ;
if x < 1
	x = 1 / x ;
	invertx = 1 ;
end

if strcmp( 'E12', str )
	v = x * E12 ;
elseif strcmp( 'E24', str )
	v = x * E24 ;
end

v = [ v ; 10*v ] ;

M = v * ( 1 ./( v.' ) ) ;
G = abs( M - x ) ;


[r,c]=find( G == min( min( G ) ) ) ;

Re = M( r, 1 ) ;
Rf = 1 ./ M( 1, c ) ;
if invertx
	P = Re ; Re = Rf ; Rf = P ;
end
