function f010301
% figure 1.3.1 - time-domain function
% figure 1.3.2 - complex-spectrum at t=0
% figure 1.3.x - complex-spectrum at t=pi/4w

% RXon, 020518

T=5;
tau=0.5;
w0=2*pi/tau;
dt=pi/(4*w0);
N=128;

t=( -T : 2*T/(N-1) : T );
x=max(find( t < -tau ));
y=[zeros(x,1); -ones(length(t)/2-x,1); ones(length(t)/2-x,1); zeros(x,1)];
figure(1)
plot(t,y)
axis([-5,5,-5,5]);

y=[y;y;y;y;y;y;y;y;y;y];
Y=fft(y);
Y=[abs(Y(1+length(Y)/2:length(Y))); -abs(Y(1:length(Y)/2))];
dw=2*pi/T;
w=dw*(-0.5+(1-length(Y)/2:length(Y)/2).');
% whos
figure(2)
% plot( Y )
plot3( [w(1), w(N)],  [0, 0], [0, 0],...
       [0, 0],  [-T-1, T+1], [0, 0],...
       [0, 0],  [0, 0], 2*[-T-1, T+1],...
            w, imag(Y),     real(Y) )
view([40,30]);

y=y(1:N);
Y=fft(y);
Y=[abs(Y(1+length(Y)/2:length(Y))); -abs(Y(1:length(Y)/2))];
dw=2*pi/T;
w=dw*(-0.5+(1-length(Y)/2:length(Y)/2).');
% whos
figure(3)
% plot( Y )
plot3( [w(1), w(N)],  [0, 0], [0, 0],...
       [0, 0],  [-T-1, T+1], [0, 0],...
       [0, 0],  [0, 0], 2*[-T-1, T+1],...
            w, imag(Y),     real(Y) )
view([40,30]);


