function xjw2(z,p)
% XJW2	compleX frequency response, s=c+j*w.
%
%		Call :			xjw2( z, p ) ;
%
%		where:			z --> system zeros
%						p --> system poles
%
%		xjw2 plots the complex frequency responses of the
%		system, determined by poles and zeros (if any) over
%		the complex frequency plane.
%		If there are no imput arguments, F(s)=1/s is ploted.

% RXon, 001021
% Last rev. : 001126

if nargin < 2
	if nargin < 1
		p=0;
		z=[];
	else
		p=[];
	end
end

% d=5;
d=2.5;
b=1/100;
w=(-d:b:d);
g=length(w);
% x=[0, logspace(-1,2,31)];
x=[0, logspace(-(1-log10(2)),(2-log10(2)),17)];
n=length(x);

for k=1:n
	if ~isempty(z)
		eval( [ 'H', num2str(k), '=pats(z,x(k)+j*w);' ] );
	else
		eval( [ 'H', num2str(k), '=ones(1,g);' ] );
	end

	if ~isempty(p)
		eval( [ 'H', num2str(k), '=H', num2str(k), ' ./ pats(p,x(k)+j*w);' ] );
	end
end

plot3( [0,0],[-d,d],[0,0],'-k',...
       [0,0],[0,0],[-d,d],'-k',...
       [0,2*d],[0,0],[0,0],'-k');
axis([0,2*d,-d,d,-d,d]);
view(30,10);
% title( [ '\itF\rm(\its\rm) = 1/\its' ] ) ;
% xlabel( [ '\Re\{\its\rm\}' ] ) ;
xlabel( ['\Re\{\itF\rm(\its\rm)\}' ] ) ;
ylabel( ['\Im\{\its\rm\}' ] ) ;
zlabel( ['\Im\{\itF\rm(\its\rm)\}' ] ) ;
hold on

t=find(abs(H1)>d);
u=min(t);
v=max(t);
plot3( real(H1(1:u-1)), w(1:u-1), imag(H1(1:u-1)), '-b',...
       real(H1(1+v:g)), w(1+v:g), imag(H1(1+v:g)), '-b' );

for k = 2:n
	eval( [ 'plot3( real(H', num2str(k), '), w, imag(H', num2str(k), '), ''-b'' )' ] );
end
axis( 'equal' );
