function zcomplex
% ZCOMPLEX plots of complex function F(z)=1/z
%          Experimental.

% RXon, 011209

M=3;
m=2*M/(2*8*M-1);
x=(-M:m:M);
nx=length(x)
a=nx^2 ;
b=x((nx/2)+(-2:2)) ;
y=j*x;

[X,Y]=meshgrid(x,y);
F=1 ./(X+Y);
for h=1:nx
	for k=1:nx
		if real( F(h,k) ) > 3
			F(h,k)=3+j*imag( F(h,k) );
		end
		if real( F(h,k) ) < -3
			F(h,k)=-3+j*imag( F(h,k) );
		end
		if imag( F(h,k) ) > 3
			F(h,k)=real( F(h,k) )+j*3;
		end
		if imag( F(h,k) ) < -3
			F(h,k)=real( F(h,k) )-j*3;
		end
	end
end

figure(1)
% mesh( real(X), imag(Y), real(F) )
surfl( real(X), imag(Y), real(F) )
shading interp;
colormap( 'copper' );
xlabel('\sigma')
ylabel('\omega')
zlabel('\Re\{\itF\rm(\itz\rm)\}')
axis([-3,3,-3,3,-3,3]);
axis equal ;
view(27,20);

figure(2)
% mesh( real(X), imag(Y), imag(F) );
surfl( real(X), imag(Y), imag(F) );
shading interp;
colormap( 'copper' );
xlabel('\sigma')
ylabel('\omega')
zlabel('\Im\{\itF\rm(\itz\rm)\}')
axis([-3,3,-3,3,-3,3]);
axis equal ;
view(27,20);

F = 1 ./(X+Y) ;
Fr = real( F ) ;
Fi = imag( F ) ;
a = 4.25 ;
for h=1:nx
	for k=1:nx
		if Fr(h,k) > a
			Fr(h,k) = a ;
		end
		if Fi(h,k) > a
			Fi(h,k) = a ;
		end
		if Fr(h,k) < -a
			Fr(h,k) = -a ;
		end
		if Fi(h,k) < -a
			Fi(h,k) = -a ;
		end
	end
end
F = Fr + j*Fi ;
A = abs( F ) ;
figure(3)
% mesh( real(X), imag(Y), A );
surfl( real(X), imag(Y), A );
colormap( 'copper' );
shading interp;
xlabel('\sigma')
ylabel('\omega')
zlabel('|\itF\rm(\itz\rm)|')
axis([-3,3,-3,3,0,6]);
axis equal ;
view(27,20);
