function S=tcoilkld(plotflag)
% T-coil coupling factor (k) as a function of the
% length-to-diameter (l/D) ratio.

if ~nargin
	plotflag = 0 ;
end

S(:,1) = [ 0.02; 0.05; 0.10; 0.15; 0.25; 0.45; 0.65; 1.00; 1.50; 2.05; 2.50; 4.00 ] ;
S(:,2) = [ 0.75; 0.70; 0.65; 0.61; 0.54; 0.45; 0.39; 0.31; 0.24; 0.19; 0.16; 0.10 ] ;

if plotflag
	loglog( S(:,1), S(:,2), '-b', S(:,1), S(:,2), 'or' )
	% axis([0.02 10.0 0.10 0.80])
	grid
end

