function ierr
%IERR	I (current) ERRor of a Current-FeedBack Amplifier under step response.
%	Trans-Impedance Equation :
%					Vo = Ie * Zt
%	Feedback Error Current :
%					Ie = Vi/Rp + (Vi-Vo)/Rs =
%					   = Vi*(Rs+Rp)/(Rs*Rp) - Vo/Rs
%	Trans-Impedance Model :
%					Zt = 1/(1/Rt + j*w*Ct)
%	Closed-Loop Gain :
%				     Vo/Vi = (1+Rs/Rp)/(1+Rs/Zt) =
%			= (1+Rs/Rp)/((1+Rs/Rt)*(1+j*w*Ct*Rs*Rt/(Rs+Rt)))
%	Open-Loop Gain :
%				     Vo/Vi = Rt/(Rp*(1+j*w*Ct*Rt))
%	Non-Ideal Closed-Loop Gain :
%	    Vo/Vi = 1 ./((Rr+Rs*Rp/(Rs+Rp))*(1/Rt+w*Ct+1/(Rs+Rp*Rr/(Rp+Rr))))
%	Ie in time domain :
%	   Ie = Vi*(1/Rs+1/Rp)*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))))


%	E.M., 920702

Rs=2700;	 %[]
Rp=300;		 %[]
Rt=27000;	 %[]
Ct=220*10^(-12); %[F]
Rr=15;		 %[]

nt=101;
t=.45*(0:1:nt-1)*10^(-7);
z=round(nt/9);
Vi1=ones(t);
Vi2=1-exp(-t/(Ct*Rs));
Vi3=1-exp(-t/(2*Ct*Rs));

G=4;
Vi1=G*Vi1;
Vi2=G*Vi2;
Vi3=G*Vi3;

% ----- ierr -------
Ie1=(1/Rs+1/Rp)*Vi1.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie1=1000*([zeros(1:z+1) Ie1(1:nt-z-1)]);	%[mA]

Ie2=(1/Rs+1/Rp)*Vi2.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie2=1000*([zeros(1:z) Ie2(1:nt-z)]);		%[mA]

Ie3=(1/Rs+1/Rp)*Vi3.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie3=1000*([zeros(1:z) Ie3(1:nt-z)]);		%[mA]

t=1000000*t;					%[s]
t=t-.5;
plot(t,Ie1,'-r',t,Ie2,'-g',t,Ie3,'-b',0,-1)
% title('Feedback Error Current for a 1V Input Step')
% xlabel('Time [us]')
% ylabel('Current [mA]')
pause

disp('max(Ie1)   max(Ie2)   max(Ie3)   Ie1(101)')
disp('---------------------------------------------')
disp([max(Ie1) max(Ie2) max(Ie3) Ie1(101)])
