function [v,t]=crtev(Va,lac,plt)
% CRTEV	Cathode-Ray Tube Electron Velocity.
%
%			Call :	[v,t]=crtev(Va,lac,plt);
%			where:	Va --> CRT anode voltage in Volts
%						lac--> anode-cathode field length in meters
%						plt--> optional graph ploting if non-zero
%						v  --> electron beam velocity in m/s
%						t  --> time of flight
%
%			The routine takes into account the relativistic mass
%			increase with the electron acceleration.

% RXon, 090703

% constants and starting values
c = 299792458 ; % [m/s] speed of light in vacuum
qe = 1.6022e-019 ; % [As] electron charge (absolute value)
me = 9.1094e-031 ; % [kg] electron mass

if nargin < 3
   plt = 0 ;
end

k = 1 ;	% counting index

% initial velocity
v(:,k) = 0 ;

% initial distance
x(:,k) = 0 ;

% initial relativistic mass
mr(:,k) = me ;

% time scale incremet
dt = 1e-12 ; % [s]

% initial acceleration
a(:,k) = qe * Va / ( mr(k) * lac ) ; % [m/s^2]

k = 2 ;	% counting index

% velocity after the first dt interval
v(:,k) = v(k-1) + a(k-1) * dt ;

% relativistic mass increase
mr(:,k) = me / sqrt( 1 - ( v(k)/c )^2 ) ;

% distance traveled
x(:,k) = a(k-1) * dt^2 / 2 ;

% loop
while ( x(k) < lac ) & ( v/c < 1 )
	a(:,k) = qe * Va / ( mr(k) * lac ) ; % [m/s^2]
   k = k + 1 ;
   v(:,k) = v(k-1) + a(k-1) * dt ;
	mr(:,k) = me / sqrt( 1 - ( v(k)/c )^2 ) ;
	% x(:,k) = x(k-1) + a(k-1) * dt^2 / 2 ;
   x(:,k) = x(k-1) + ( v(k-1) + ( v(k) - v(k-1) )/2 ) * dt ;
 	% disp([k, x(k)/lac, a(k-1)/a(1), v(k)/c, mr(k)/me]) ;
end

% time scale
t = ( 0 : 1 : k-1  ) * dt / 1e-12 ; % [ps]
% time intervals
ti = t(1:k-1) + dt/2e-12 ;

plot( t, v/c, '-r',...
		t, mr/me, '-b',...
      ti, a/a(1), '-g',...
      t, x/lac, '-k' )
   
xlabel( 'time [ps]' );
