function Gff=ffgfd(A01,A02,beta,flow,fhi,m)
% FFGFD : Feedforward amplifier gain frequency dependence.
% 28.03.2004.

if  nargin < 6
    m = 1 ;
end
if nargin < 5
    fhi = 100 ;
end
if nargin < 4
    flow = 0.01 ;
end
if nargin < 3
    beta = 10 ;
end
if nargin < 2
    A02 = 1/beta ;
end
if ~nargin
    A01 = 1/beta ;
end

f=logspace( log10(flow), log10(fhi), 401 );
s=j*2*pi*f;
s1=-2*pi;
s2=m*s1;

A1 = A01*(-s1) ./(s-s1);
A2 = A02*(-s2) ./(s-s2);
Gff = A1 + A2 -beta*A1.*A2;

loglog( f, abs(A1), f, abs(A2), f, abs(Gff), [f(1),f(length(f))], [1,1]*abs(Gff(1))/sqrt(2) )

