function filt7rc(psel,tst)
% FILT7RC	R & C values for the 7th-order analogue part of the
%		13th-order compound a+d system.

% RXon, 000417

if nargin < 2
	tst = 0 ;
end
if nargin < 1
	psel = 0 ;
end
n=13;		% system order
fs=2e+6;	% system sampling frequency, 2MHz ;
fn=fs/2;	% Nyquist frequency ;
Br=12;		% ADC resolution, bits ;
Ar=1/2^Br;	% resolution level ;

Bwi=1.73;	% badwidth improvement factor ;
% Bwi=1.67;	% badwidth improvement factor ;

% 7th-order system asymptote, crossing Ar at fn, has the corner frequency at :
fa=fn/10^( ( log10( (1/Ar)^2 -1 ) ) / ( 2 * 7 ) ) ;

% 13th-order Bessel-Thomson system poles, asymptote-normalized :
[z13,p13]=bestap(n,'a');

% shit it to actual system frequency ;
p13=p13*fa*Bwi;

% select the 7 poles for the analogue-part ;
if psel
	p7=p13([1,8,9,10,11,12,13]);
	p6=p13([2,3,4,5,6,7]);
else
	p7=p13([1,4,5,8,9,12,13]);
	p6=p13([2,3,6,7,10,11]);
end

% test system response :
if tst
	[z70,p70]=bestap(7,'a');
	w=logspace(5,7,401);
	F70=20*log10(abs(freqw(p70*fa,w)));
	F71=20*log10(abs(freqw(p7,w)));
	F61=20*log10(abs(freqw(p6,w)));
	F13=20*log10(abs(freqw(p13,w)));
	nb=max(find(F71>-80));
	nn=max(find(w<=fn));
	na=max(find(F71>20*log10(Ar)));
	Fa=F71(nn:na);
	semilogx( w(1:nn), F70(1:nn), '-k', ...
		  w(1:nb), F71(1:nb), '-r', ...
		  w(1:nb), F61(1:nb), '-b', ...
		  w(1:nn), F13(1:nn), '-m', ...
		  w(nn:na),       Fa, '-g', ...
		  fs-w(nn:na),    Fa, '-g', ...
		  fs-w(nn:na), 20*log10(Ar)-Fa, '-c', ...
		  w([1,401]), 20*log10(Ar)*[1,1], '-k')
end

% for actual R & C values multiply the poles by 2*pi :
p7=2*pi*p7;

% configuration : Multiple-Feedback type, 3+2+2 stages
sg=100;		% total system gain ;
Ao=sg^(1/3);	% gain per stage ;

% ------------ 3rd-orser stage : ------------
% General 3rd-order pole-defined polynomial :
%   1 / ( (s-s1) * (s-s2) * (s-s3) ) = 
% = 1 / ( s^3 - s^2*(s1+s2+s3) + s*(s1*s2+s1*s3+s2*s3) - s1*s2*s3 ) =
% = 1 / ( s^3 + s^2*x + s*y + z )
%
% x = -(s1 + s2 + s3) ;
% y = s1*s2 + s1*s3 + s2*s3 ;
% z = -(s1 * s2 * s3) ;
%
% Transfer function :
%			z  
% H(s) = -Ao ----------------------------
%	      p^3 + p^2 * x + p * y + z
%
% Ao=R2/(2*R);
% wo=z^(1/3);
% x=(2+1/(2*Ao))*(1/(R*C2))+(2/(R*C3));
% y=(3+1/Ao)*(1/(R^2*C2*C3))+(1/(2*Ao))*(1/(R^2*C1*C2));
% z=(1/Ao)*(1/(R^3 * C1 * C2 * C3);


x = -real( p7(1) + p7(2) + p7(3) ) ;
y =  real( p7(1) * p7(2) + p7(1) * p7(3) + p7(2) * p7(3) ) ;
z = -real( p7(1) * p7(2) * p7(3) ) ;

% Ao=1;		% set gain to 1 for the test !!!
% -----------------------------------------------------------
% solve the general-form of the 3rd-order equation :
%
%	(C3)^3 + p * (C3)^2 + q * (C3) + r = 0
%
% Solutions form the "Active Filter Cook-Book" by E.Margan :
% -----------------------------------------------------------
R = 1000 ;
k=2*(3*Ao+1)/(4*Ao+1);	% corrected 000421
p=-2*y/(z*R);		% p=-2*y/z;
q=k*2*x/(z*R^2);	% q=k*2*x/z;
% r=-k*4/z;		% originally : r=+k*4/z;
r=k*4/(z*R^3);		% !!!---- sign ????----!!!!!
% p,q,r

% C3 = 4*r*p^3 - p^2 * q^2 - 18*p*q*r + 4*q^3 + 27*r^2 ;
% C3 = sqrt( -C3/((p^2 - 3*q)^3) ) / (9*C3) ;
% C3 = sqrt(3) * ( ( p^2 - 3*q )^(3/2) ) * ( 2*p^3 - 9*p*q + 27*r ) * C3 ;
% C3 = -(2/3) * sqrt( p^2 -3*q ) * sin( atan( C3 ) / 3 ) - p/3 ;

C3 = 4*(p^3)*r - (p^2)*(q^2) - 18*p*q*r + 4*(q^3) + 27*(r^2);
C3 = sqrt(-1) * ( 2*(p^3) - 9*p*q + 27*r ) / ( 3 * sqrt( 3 * C3 ) ) ;
C3 = -(2/3) * sqrt( (p^2) - 3*q ) * sin( (1/3) * atan( C3 ) ) - p/3 ;
if imag(C3) > 1e-5*real(C3)
	disp(['>>WARNING!!! :  C3 has an imaginary component !!!<<']);
	disp(['  imag(C3) = ', num2str( imag(C3) )]);
end
C3=real(C3);

% C2 = (1+1/Ao) / ( y*C3 - (z/2)*C3^2 ) ;
C2 = (3+1/Ao) / ( y*C3*R^2 - (z/2)*C3^2*R^3 ) ;
% C2=real(C2);

% C1 = 1 / ( z*Ao*C2*C3 ) ;			% from z !
C1 = 1 / ( z*Ao*C2*C3*R^3 ) ;			% from z !
% C1 = C3 / ( 2*Ao*y*C2*C3 - 2*(Ao+1) ) ;	% from x - originally !
% C1=real(C1);

% display and test :
disp(' ');
disp(' ------ 3rd-order stage : -----------------------------------');
disp(['  Ao = ', num2str(Ao), '   R1=R3=R4 = ',num2str(R), ' ohm     R2 = ', num2str(2*R*Ao),' ohm']);
disp(['  C3 = ', num2str(C3*1e+9), ' nF      C2 = ', num2str(C2*1e+9), ' nF    C1 = ', num2str(C1*1e+9), ' nF']);
disp(['  f3 = ', num2str((1e-3)/(2*pi*R*(Ao*C1*C2*C3)^(1/3))), ' kHz     fp = ', num2str((1e-3)*z^(1/3)/(2*pi)), ' kHz']);
disp(' ------------------------------------------------------------');


% ----------- First 2dn-order stage -------------------------------
% Ao = R2/R3 ;
% R1=R3=R
% wo = 1 / sqrt( Ao * R1*R3*C1*C2 ) ;
% wo/Q = ( 2+1/Ao ) / ( R2*C2 ) ;
%
% Transfer function :
%
%       s1*s2                   s1*s2
% ----------------- = --------------------------
%   (s-s1)*(s-s2)      s^2 - s*(s1+s2) + s1*s2
%


C1 = ( -p7(4) - p7(5) ) / ( p7(4) * p7(5) * R * ( 2*Ao + 1 ) ) ;
C2 = ( 2*Ao + 1 ) / ( Ao * R * ( -p7(4) - p7(5) ) ) ;

% display and test :
disp(' ------ first 2rd-order stage : -----------------------------');
disp(['  Ao = ', num2str(Ao), '      R1=R3 = ',num2str(R), ' ohm     R2 = ', num2str(R*Ao),' ohm']);
disp(['  C2 = ', num2str(C2*1e+9), ' nF      C1 = ', num2str(C1*1e+9), ' nF']);
disp(['  f3 = ', num2str((1e-3)/(2*pi*sqrt(Ao*R^2*C1*C2))), ' kHz     fp = ', num2str((1e-3)*sqrt(p7(4)*p7(5))/(2*pi)), ' kHz']);
disp(' ------------------------------------------------------------');

% ----------- Second 2dn-order stage -------------------------------
% Ao = R2/R3 ;
% R1=R3=R
% wo = 1 / sqrt( Ao * R1*R3*C1*C2 ) ;
% wo/Q = ( 2+1/Ao ) / ( R2*C2 ) ;
%
% Transfer function :
%
%       s1*s2                   s1*s2
% ----------------- = --------------------------
%   (s-s1)*(s-s2)      s^2 - s*(s1+s2) + s1*s2
%


C1 = ( -p7(6) - p7(7) ) / ( p7(6) * p7(7) * R * ( 2*Ao + 1 ) ) ;
C2 = ( 2*Ao + 1 ) / ( Ao * R * ( -p7(6) - p7(7) ) ) ;

% display and test :
disp(' ------ second 2rd-order stage : ----------------------------');
disp(['  Ao = ', num2str(Ao), '      R1=R3 = ',num2str(R), ' ohm     R2 = ', num2str(R*Ao),' ohm']);
disp(['  C2 = ', num2str(C2*1e+9), ' nF      C1 = ', num2str(C1*1e+9), ' nF']);
disp(['  f3 = ', num2str((1e-3)/(2*pi*sqrt(Ao*R^2*C1*C2))), ' kHz     fp = ', num2str((1e-3)*sqrt(p7(6)*p7(7))/(2*pi)), ' kHz']);
disp(' ------------------------------------------------------------');
disp(' ')

